/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.gitpatcher;

import ca.stellardrift.gitpatcher.PatchExtension;
import javax.inject.Inject;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ProviderFactory;

class PatchExtensionImpl
implements PatchExtension {
    private final DirectoryProperty root;
    private final Property<String> submodule;
    private final DirectoryProperty target;
    private final DirectoryProperty patches;
    private final Property<Boolean> addAsSafeDirectory;
    private final Property<String> committerNameOverride;
    private final Property<String> committerEmailOverride;

    @Inject
    public PatchExtensionImpl(ObjectFactory objects, ProviderFactory providers, ProjectLayout layout) {
        this.root = objects.directoryProperty().convention(layout.getProjectDirectory());
        this.submodule = objects.property(String.class);
        this.target = objects.directoryProperty();
        this.patches = objects.directoryProperty();
        this.addAsSafeDirectory = objects.property(Boolean.class).convention(providers.environmentVariable("GITPATCHER_ADD_GIT_SAFEDIR").map(it -> it.equals("true")).orElse((Object)false));
        this.committerNameOverride = objects.property(String.class).convention((Object)"GitPatcher");
        this.committerEmailOverride = objects.property(String.class).convention((Object)"gitpatcher@noreply");
    }

    @Override
    public DirectoryProperty getRoot() {
        return this.root;
    }

    @Override
    public Property<String> getSubmodule() {
        return this.submodule;
    }

    @Override
    public DirectoryProperty getTarget() {
        return this.target;
    }

    @Override
    public DirectoryProperty getPatches() {
        return this.patches;
    }

    @Override
    public Property<Boolean> getAddAsSafeDirectory() {
        return this.addAsSafeDirectory;
    }

    @Override
    public Property<String> getCommitterNameOverride() {
        return this.committerNameOverride;
    }

    @Override
    public Property<String> getCommitterEmailOverride() {
        return this.committerEmailOverride;
    }
}

