/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.gitpatcher;

import ca.stellardrift.gitpatcher.GitPatcherExtension;
import ca.stellardrift.gitpatcher.RepoPatchDetails;
import ca.stellardrift.gitpatcher.RepoPatchDetailsImpl;
import javax.inject.Inject;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ProviderFactory;

class GitPatcherExtensionImpl
implements GitPatcherExtension {
    private final NamedDomainObjectContainer<RepoPatchDetailsImpl> patchedRepos;
    private final Property<Boolean> addAsSafeDirectory;
    private final Property<String> committerNameOverride;
    private final Property<String> committerEmailOverride;

    @Inject
    public GitPatcherExtensionImpl(ObjectFactory objects, ProviderFactory providers) {
        this.patchedRepos = objects.domainObjectContainer(RepoPatchDetailsImpl.class);
        this.addAsSafeDirectory = objects.property(Boolean.class).convention(providers.environmentVariable("GITPATCHER_ADD_GIT_SAFEDIR").map(it -> it.equals("true")).orElse((Object)false));
        this.committerNameOverride = objects.property(String.class).convention((Object)"GitPatcher");
        this.committerEmailOverride = objects.property(String.class).convention((Object)"gitpatcher@noreply");
    }

    @Override
    public NamedDomainObjectContainer<RepoPatchDetails> getPatchedRepos() {
        return this.patchedRepos;
    }

    @Override
    public Property<Boolean> getAddAsSafeDirectory() {
        return this.addAsSafeDirectory;
    }

    @Override
    public Property<String> getCommitterNameOverride() {
        return this.committerNameOverride;
    }

    @Override
    public Property<String> getCommitterEmailOverride() {
        return this.committerEmailOverride;
    }
}

