/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.gitpatcher;

import ca.stellardrift.gitpatcher.GitPatcherExtension;
import ca.stellardrift.gitpatcher.GitPatcherExtensionImpl;
import ca.stellardrift.gitpatcher.PatchExtension;
import ca.stellardrift.gitpatcher.PatchExtensionImpl;
import ca.stellardrift.gitpatcher.internal.GitService;
import ca.stellardrift.gitpatcher.internal.Utils;
import ca.stellardrift.gitpatcher.task.FindGitTask;
import ca.stellardrift.gitpatcher.task.UpdateSubmodulesTask;
import ca.stellardrift.gitpatcher.task.patch.ApplyPatchesTask;
import ca.stellardrift.gitpatcher.task.patch.MakePatchesTask;
import java.util.stream.Stream;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;

public abstract class GitPatcher
implements Plugin<Project> {
    private static final String GITPATCHER_TASK_GROUP = "gitpatcher";

    static void applyGitPatcherGroup(Task t) {
        t.setGroup(GITPATCHER_TASK_GROUP);
    }

    public void apply(Project p) {
        this.registerBuildService(p);
        TaskProvider rootApply = p.getTasks().register("applyPatches", GitPatcher::applyGitPatcherGroup);
        TaskProvider rootRebuild = p.getTasks().register("makePatches", GitPatcher::applyGitPatcherGroup);
        TaskProvider rootUpdate = p.getTasks().register("updateSubmodules", GitPatcher::applyGitPatcherGroup);
        GitPatcherExtension extension = this.createExtension(p.getExtensions());
        TaskProvider findGit = p.getTasks().register("findGit", FindGitTask.class, GitPatcher::applyGitPatcherGroup);
        extension.getPatchedRepos().all(r -> {
            r.getAddAsSafeDirectory().convention(extension.getAddAsSafeDirectory());
            r.getCommitterNameOverride().convention(extension.getCommitterNameOverride());
            r.getCommitterEmailOverride().convention(extension.getCommitterEmailOverride());
            String capitalizedName = Utils.capitalize(r.getName());
            TaskProvider updateSubmodules = p.getTasks().register("update" + capitalizedName + "Submodules", UpdateSubmodulesTask.class, upSub -> {
                upSub.setGroup(GITPATCHER_TASK_GROUP);
                upSub.dependsOn(new Object[]{findGit});
            });
            rootUpdate.configure(it -> it.dependsOn(new Object[]{updateSubmodules}));
            TaskProvider apply = p.getTasks().register("apply" + capitalizedName + "Patches", ApplyPatchesTask.class, GitPatcher::applyGitPatcherGroup);
            rootApply.configure(it -> it.dependsOn(new Object[]{apply}));
            TaskProvider rebuild = p.getTasks().register("make" + capitalizedName + "Patches", MakePatchesTask.class, it -> {
                it.setGroup(GITPATCHER_TASK_GROUP);
                it.dependsOn(new Object[]{findGit});
            });
            rootRebuild.configure(it -> it.dependsOn(new Object[]{rebuild}));
            Stream.of(apply, rebuild).forEach(tP -> tP.configure(t -> {
                t.getAddAsSafeDirectory().convention(r.getAddAsSafeDirectory());
                t.getCommitterName().convention(r.getCommitterNameOverride());
                t.getCommitterEmail().convention(r.getCommitterEmailOverride());
                t.getRepo().set((Provider)r.getTarget());
                t.getRoot().set((Provider)r.getRoot());
                t.getSubmodule().set(r.getSubmodule());
                t.getPatchDir().set((Provider)r.getPatches());
            }));
            updateSubmodules.configure(it -> {
                it.getRepo().convention((Provider)r.getRoot());
                it.getSubmodule().convention(r.getSubmodule());
            });
            p.afterEvaluate(p2 -> apply.configure(it -> it.setUpdateTask((UpdateSubmodulesTask)((Object)((Object)((Object)((Object)updateSubmodules.get())))))));
        });
    }

    private Provider<GitService> registerBuildService(Project project) {
        return project.getGradle().getSharedServices().registerIfAbsent("ca.stellardrift.gitpatcher.git", GitService.class);
    }

    private GitPatcherExtension createExtension(ExtensionContainer extensions) {
        GitPatcherExtension extension = (GitPatcherExtension)extensions.create(GitPatcherExtension.class, "gitPatcher", GitPatcherExtensionImpl.class, new Object[0]);
        extensions.create(PatchExtension.class, "patches", PatchExtensionImpl.class, new Object[]{extension});
        return extension;
    }
}

