/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.gitpatcher.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jspecify.annotations.Nullable;

public final class Git {
    private static final Logger LOGGER = Logging.getLogger(Git.class);
    private final ExecutorService ioExecutor;
    private File repo;
    private @Nullable String committerNameOverride;
    private @Nullable String committerEmailOverride;
    private @Nullable String authorNameOverride;
    private @Nullable String authorEmailOverride;

    public Git(Path path, ExecutorService ioExecutor) {
        this.repo = path.toFile();
        this.ioExecutor = ioExecutor;
    }

    public void setRepo(File repo) {
        this.repo = repo;
        if (!repo.exists()) {
            throw new GradleException("Repo directory " + String.valueOf(repo) + " does not exist!");
        }
    }

    public void setRepo(Directory repo) {
        this.setRepo(repo.getAsFile());
    }

    public void setRepo(DirectoryProperty repo) {
        this.setRepo(((Directory)repo.get()).getAsFile());
    }

    public void setCommitterNameOverride(@Nullable String committerNameOverride) {
        this.committerNameOverride = committerNameOverride;
    }

    public void setCommitterEmailOverride(@Nullable String committerEmailOverride) {
        this.committerEmailOverride = committerEmailOverride;
    }

    public void setAuthorNameOverride(@Nullable String authorNameOverride) {
        this.authorNameOverride = authorNameOverride;
    }

    public void setAuthorEmailOverride(@Nullable String authorEmailOverride) {
        this.authorEmailOverride = authorEmailOverride;
    }

    private void decorateEnv(Map<String, String> env) {
        if (this.committerNameOverride != null) {
            env.put("GIT_COMMITTER_NAME", this.committerNameOverride);
        }
        if (this.committerEmailOverride != null) {
            env.put("GIT_COMMITTER_EMAIL", this.committerEmailOverride);
        }
        if (this.authorNameOverride != null) {
            env.put("GIT_AUTHOR_NAME", this.authorNameOverride);
        }
        if (this.authorEmailOverride != null) {
            env.put("GIT_AUTHOR_EMAIL", this.authorEmailOverride);
        }
    }

    public String getStatus() {
        return this.run("status", "-z").getText();
    }

    public String getRef() {
        return this.run("rev-parse", "HEAD").getLines().get(0).trim();
    }

    public Command add(String ... args) {
        return this.run("add", args);
    }

    public Command am(String ... args) {
        return this.run("am", args);
    }

    public Command branch(String ... args) {
        return this.run("branch", args);
    }

    public Command clone(String ... args) {
        return this.run("clone", args);
    }

    public Command checkout(String ... args) {
        return this.run("checkout", args);
    }

    public Command config(String ... args) {
        return this.run("config", args);
    }

    public Command deleteIndex(String ... args) {
        return this.run("delete-index", args);
    }

    public Command diff(String ... args) {
        return this.run("diff", args);
    }

    public Command fetch(String ... args) {
        return this.run("fetch", args);
    }

    public Command formatPatch(String ... args) {
        return this.run("format-patch", args);
    }

    public Command remote(String ... args) {
        return this.run("remote", args);
    }

    public Command reset(String ... args) {
        return this.run("reset", args);
    }

    public Command updateIndex(String ... args) {
        return this.run("update-index", args);
    }

    public Command version(String ... args) {
        return this.run("version", args);
    }

    public Command submodule(String ... args) {
        return this.run("submodule", args);
    }

    public Command run(String subcommand, String ... input) {
        ArrayList<String> args = new ArrayList<String>(input.length + 3);
        args.addAll(List.of("git", "--no-pager", subcommand));
        args.addAll(Arrays.asList(input));
        LOGGER.info("gitpatcher: executing {}", args);
        ProcessBuilder builder = new ProcessBuilder(args);
        this.decorateEnv(builder.environment());
        builder.directory(this.repo);
        try {
            return new Command(builder.start(), args, this.ioExecutor);
        }
        catch (IOException ex) {
            throw new GradleException("Failed to start command '" + String.valueOf(args) + "'", (Throwable)ex);
        }
    }

    public static final class Command {
        private final Process process;
        private final List<String> cli;
        private final ExecutorService ioExecutor;
        private static final int SKIP_SIZE = 2048;

        private Command(Process process, List<String> cli, ExecutorService ioExecutor) {
            this.process = process;
            this.cli = List.copyOf(cli);
            this.ioExecutor = ioExecutor;
        }

        public int awaitCompletion() {
            int result;
            try {
                result = this.process.waitFor();
            }
            catch (InterruptedException ex) {
                throw new GradleException("Interrupted while waiting for process completion", (Throwable)ex);
            }
            return result;
        }

        public void expectSuccess() {
            int result = this.awaitCompletion();
            if (result != 0) {
                throw new GradleException("Process returned error code %d.\nInvoked process: %s\n".formatted(result, String.join((CharSequence)" ", this.cli)));
            }
        }

        public void writeTo(OutputStream out) {
            this.consumeStream(this.process.getInputStream(), out);
            this.consumeStream(this.process.getErrorStream(), System.err);
            this.expectSuccess();
        }

        void forceWriteTo(OutputStream out) {
            this.consumeStream(this.process.getInputStream(), out);
            this.consumeStream(this.process.getErrorStream(), out);
            this.awaitCompletion();
        }

        public void awaitCompletionSilently() {
            this.consumeStream(this.process.getErrorStream(), System.err);
            this.awaitCompletion();
        }

        public void expectSuccessSilently() {
            this.consumeStream(this.process.getErrorStream(), System.err);
            this.expectSuccess();
        }

        public String getText() {
            this.consumeStream(this.process.getErrorStream(), System.err);
            String stdout = this.readText0();
            this.expectSuccess();
            return stdout;
        }

        public List<String> getLines() {
            List<String> list;
            block8: {
                this.consumeStream(this.process.getErrorStream(), System.err);
                BufferedReader reader = this.process.inputReader(StandardCharsets.UTF_8);
                try {
                    List<String> ret = reader.lines().toList();
                    this.expectSuccess();
                    list = ret;
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new GradleException("Unable to read command output", (Throwable)ex);
                    }
                }
                reader.close();
            }
            return list;
        }

        public @Nullable String forceGetText() {
            this.consumeStream(this.process.getErrorStream(), System.err);
            String text = this.readText0();
            return this.awaitCompletion() == 0 ? text : null;
        }

        private void consumeStream(InputStream processStream, OutputStream target) {
            this.ioExecutor.submit(() -> processStream.transferTo(target));
        }

        private void swallowStream(InputStream swallowStream) {
            this.ioExecutor.submit(() -> {
                long skipped;
                while ((skipped = swallowStream.skip(2048L)) == 2048L) {
                }
                return null;
            });
        }

        private String readText0() {
            String stdout;
            try {
                stdout = new String(this.process.getInputStream().readAllBytes(), StandardCharsets.UTF_8);
            }
            catch (IOException ex) {
                throw new GradleException("Failed to read standard output from process '" + this.process.info().commandLine().orElseThrow() + "'", (Throwable)ex);
            }
            return stdout;
        }
    }
}

