/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.gitpatcher.task;

import ca.stellardrift.gitpatcher.internal.Git;
import ca.stellardrift.gitpatcher.internal.GitService;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.ServiceReference;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;

@UntrackedTask(because="Always check for Git in the environment when requested")
public abstract class FindGitTask
extends DefaultTask {
    @Internal
    public abstract DirectoryProperty getRootDir();

    @ServiceReference(value="ca.stellardrift.gitpatcher.git")
    protected abstract Property<GitService> getGitService();

    public FindGitTask() {
        this.getRootDir().set(this.getProject().getRootDir());
    }

    @TaskAction
    void findGit() {
        Git git = ((GitService)this.getGitService().get()).git().create((Provider<? extends Directory>)this.getRootDir());
        try {
            String version = String.join((CharSequence)",", git.version(new String[0]).getLines());
            this.getLogger().lifecycle("Using {} for patching submodules.", new Object[]{version});
        }
        catch (Throwable ex) {
            throw new UnsupportedOperationException("Failed to verify Git version. Make sure running the Gradle build in an environment where Git is in your PATH.", ex);
        }
    }
}

