/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.gitpatcher.task.patch;

import ca.stellardrift.gitpatcher.internal.Git;
import ca.stellardrift.gitpatcher.internal.GitService;
import ca.stellardrift.gitpatcher.internal.Utils;
import ca.stellardrift.gitpatcher.task.patch.PatchTask;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.jspecify.annotations.Nullable;

@UntrackedTask(because="State is tracked by git")
public abstract class ApplyPatchesTask
extends PatchTask {
    public ApplyPatchesTask() {
        this.getDestRepo().set((Provider)this.getRepo());
        this.getOutputs().upToDateWhen($ -> {
            if (!((Directory)this.getRepo().get()).getAsFile().isDirectory()) {
                return false;
            }
            Git git = ((GitService)this.getGitService().get()).git().create((Directory)this.getRepo().get(), this.getLogger());
            return git.getStatus().isEmpty() && Objects.equals(this.getCachedRef(), git.getRef()) && Objects.equals(this.getCachedSubmoduleRef(), this.readRefFile());
        });
    }

    @InputFile
    public abstract RegularFileProperty getSubmoduleRefFile();

    @Override
    @Internal
    public abstract DirectoryProperty getPatchDir();

    @Override
    @InputFiles
    public File @Nullable [] getPatches() {
        return super.getPatches();
    }

    @OutputDirectory
    public abstract DirectoryProperty getDestRepo();

    @Override
    @OutputFile
    public Provider<RegularFile> getRefCache() {
        return super.getRefCache();
    }

    private String readRefFile() {
        try {
            return Files.readString(((RegularFile)this.getSubmoduleRefFile().get()).getAsFile().toPath(), StandardCharsets.UTF_8).trim();
        }
        catch (IOException ex) {
            throw new GradleException("Unable to read ref file for submodule", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    void applyPatches() throws IOException {
        File repoFile = ((Directory)this.getRepo().get()).getAsFile();
        final Git git = ((GitService)this.getGitService().get()).git().create(this.getSubmoduleRoot(), this.getLogger());
        PatchTask.RepoState safeState = this.setupGit(git);
        try {
            File[] patches;
            git.branch("-f", "upstream").expectSuccess();
            Path rootDir = ((Directory)this.getRepo().get()).getAsFile().toPath();
            Path gitDir = rootDir.resolve(".git");
            if (!Files.isDirectory(gitDir, new LinkOption[0]) || Utils.isEmptyDir(gitDir)) {
                this.getLogger().lifecycle("Creating {} repository...", new Object[]{repoFile});
                if (!Utils.deleteRecursively(gitDir)) {
                    throw new GradleException("Failed to delete existing patched repo.");
                }
                git.setRepo(this.getRoot());
                Path gitKeep = rootDir.resolve(".gitkeep");
                if (Files.deleteIfExists(gitKeep)) {
                    git.updateIndex("--assume-unchanged", gitKeep.toAbsolutePath().toString()).awaitCompletion();
                }
                Files.walkFileTree(rootDir, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        Path keep = dir.resolve(".gitkeep");
                        if (Files.deleteIfExists(keep)) {
                            git.deleteIndex("--assume-unchanged", keep.toAbsolutePath().toString()).awaitCompletion();
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, @Nullable IOException exc) throws IOException {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) {
                        return FileVisitResult.CONTINUE;
                    }
                });
                git.clone("--recursive", (String)this.getSubmodule().get(), ((Directory)this.getRepo().get()).getAsFile().getAbsolutePath(), "-b", "upstream").writeToLog();
            }
            this.getLogger().lifecycle("Resetting {}...", new Object[]{repoFile});
            git.setRepo(this.getRepo());
            git.remote("set-url", "origin", ((Directory)this.getSubmoduleRoot().get()).getAsFile().getAbsolutePath()).expectSuccess();
            git.fetch("origin").expectSuccess();
            git.checkout("-B", "master", "origin/upstream").expectSuccess();
            git.reset("--hard").writeToLog();
            File patchDir = ((Directory)this.getPatchDir().get()).getAsFile();
            if (!patchDir.isDirectory() && patchDir.mkdirs()) {
                throw new GradleException("Failed to create patch directory");
            }
            if ("true".equalsIgnoreCase(git.config("commit.gpgsign").forceGetText())) {
                this.getLogger().warn("Disabling GPG signing for the gitpatcher repository");
                git.config("commit.gpgsign", "false").writeToLog();
            }
            if ((patches = this.getPatches()) != null && patches.length > 0) {
                this.getLogger().lifecycle("Applying patches from {} to {}", new Object[]{((Directory)this.getPatchDir().get()).getAsFile(), repoFile});
                git.am("--abort").awaitCompletionSilently();
                git.am((String[])Stream.concat(Stream.of("--3way"), Arrays.stream(patches).map(File::getAbsolutePath)).toArray(String[]::new)).writeToLog();
                this.getLogger().lifecycle("Successfully applied patches from {} to {}", new Object[]{((Directory)this.getPatchDir().get()).getAsFile(), repoFile});
            }
            Files.writeString(((RegularFile)this.getRefCache().get()).getAsFile().toPath(), (CharSequence)(git.getRef() + "\n" + this.readRefFile()), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        finally {
            this.cleanUpSafeRepo(git, safeState);
        }
    }
}

