/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.gitpatcher.task.patch;

import ca.stellardrift.gitpatcher.internal.Git;
import ca.stellardrift.gitpatcher.internal.GitService;
import ca.stellardrift.gitpatcher.task.patch.PatchTask;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.jspecify.annotations.Nullable;

@UntrackedTask(because="State is tracked by git")
public abstract class MakePatchesTask
extends PatchTask {
    private static final Predicate<String> HUNK = it -> it.startsWith("@@");

    public MakePatchesTask() {
        this.getOutputs().upToDateWhen($ -> {
            if (!((Directory)this.getRepo().get()).getAsFile().isDirectory()) {
                return false;
            }
            Git git = ((GitService)this.getGitService().get()).git().create((Provider<? extends Directory>)this.getRepo(), this.getLogger());
            return Objects.equals(this.getCachedRef(), git.getRef());
        });
    }

    @Override
    @InputDirectory
    public abstract DirectoryProperty getRepo();

    @Override
    @Internal
    public Provider<RegularFile> getRefCache() {
        return super.getRefCache();
    }

    @Override
    @OutputDirectory
    public abstract DirectoryProperty getPatchDir();

    @Override
    @Internal
    public File @Nullable [] getPatches() {
        return super.getPatches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    void makePatches() {
        File patchDir = ((Directory)this.getPatchDir().get()).getAsFile();
        if (patchDir.isDirectory()) {
            File[] patches = this.getPatches();
            if (patches != null && patches.length > 0) {
                for (File patch : patches) {
                    if (patch.delete()) continue;
                    throw new GradleException("Falied to delete old patch " + String.valueOf(patch));
                }
            }
        } else if (!patchDir.mkdirs()) {
            throw new GradleException("Failed to create patch directory");
        }
        Git git = ((GitService)this.getGitService().get()).git().create((Provider<? extends Directory>)this.getRepo(), this.getLogger());
        PatchTask.RepoState safeState = this.setupGit(git);
        try {
            git.formatPatch("--no-stat", "--zero-commit", "--full-index", "--no-signature", "-N", "-o", patchDir.getAbsolutePath(), "origin/upstream").expectSuccess();
            git.setRepo(this.getRoot());
            git.add("-A", patchDir.getAbsolutePath()).writeToLog();
            this.setDidWork(false);
            for (File patch : this.getPatches()) {
                List<String> diff = git.diff("--no-color", "-U1", "--staged", patch.getAbsolutePath()).getLines();
                if (MakePatchesTask.isUpToDate(diff)) {
                    this.getLogger().lifecycle("Skipping {} (up-to-date)", new Object[]{patch.getName()});
                    git.reset("HEAD", patch.getAbsolutePath()).expectSuccess();
                    git.checkout("--", patch.getAbsolutePath()).expectSuccess();
                    continue;
                }
                this.setDidWork(true);
                this.getLogger().lifecycle("Generating {}", new Object[]{patch.getName()});
            }
        }
        finally {
            this.cleanUpSafeRepo(git, safeState);
        }
    }

    private static boolean isUpToDate(List<String> diff) {
        if (diff.isEmpty()) {
            return true;
        }
        if (diff.contains("--- /dev/null")) {
            return false;
        }
        long count = diff.stream().filter(HUNK).count();
        if (count == 0L) {
            return true;
        }
        if (count > 2L) {
            return false;
        }
        for (int i = 0; i < diff.size(); ++i) {
            String change;
            if (!HUNK.test(diff.get(i)) || (change = diff.get(i + 1)).startsWith("From", 1) || change.startsWith("--", 1)) continue;
            return false;
        }
        return true;
    }
}

