/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.gitpatcher.task.patch;

import ca.stellardrift.gitpatcher.internal.Git;
import ca.stellardrift.gitpatcher.task.SubmoduleTask;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Internal;
import org.jspecify.annotations.Nullable;

public abstract class PatchTask
extends SubmoduleTask {
    private static final String SAFE_DIRECTORY = "safe.directory";
    private @Nullable List<String> cachedRefs;

    @Internal
    public abstract DirectoryProperty getRoot();

    public abstract DirectoryProperty getPatchDir();

    @Console
    public abstract Property<Boolean> getAddAsSafeDirectory();

    @Console
    public abstract Property<String> getCommitterName();

    @Console
    public abstract Property<String> getCommitterEmail();

    protected File @Nullable [] getPatches() {
        File patchDir = ((Directory)this.getPatchDir().get()).getAsFile();
        if (!patchDir.isDirectory()) {
            return new File[0];
        }
        Object[] patchFiles = patchDir.listFiles((dir, name) -> name.endsWith(".patch"));
        if (patchFiles != null) {
            Arrays.sort(patchFiles);
        }
        return patchFiles;
    }

    @Internal
    public Provider<Directory> getSubmoduleRoot() {
        return this.getRoot().zip(this.getSubmodule(), Directory::dir);
    }

    @Internal
    Provider<Directory> getGitDir() {
        return this.getRepo().map(it -> it.dir(".git"));
    }

    Provider<RegularFile> getRefCache() {
        return this.getGitDir().map(it -> it.file(".gitpatcher_ref"));
    }

    private void readCache() {
        block10: {
            if (this.cachedRefs == null) {
                File refCache = ((RegularFile)this.getRefCache().get()).getAsFile();
                if (refCache.isFile()) {
                    try (Stream<String> lines = Files.lines(refCache.toPath());){
                        this.cachedRefs = lines.map(String::trim).filter(it -> !it.isEmpty() && !it.startsWith("#")).toList();
                        break block10;
                    }
                    catch (IOException ex) {
                        this.cachedRefs = List.of();
                        throw new GradleException("Unable to read ref cache", (Throwable)ex);
                    }
                }
                this.cachedRefs = List.of();
            }
        }
    }

    @Internal
    String getCachedRef() {
        this.readCache();
        return this.cachedRefs.get(0);
    }

    @Internal
    String getCachedSubmoduleRef() {
        this.readCache();
        return this.cachedRefs.get(1);
    }

    protected @Nullable RepoState setupGit(Git git) {
        if (this.getCommitterName().isPresent()) {
            git.setCommitterNameOverride((String)this.getCommitterName().get());
        }
        if (this.getCommitterEmail().isPresent()) {
            git.setCommitterEmailOverride((String)this.getCommitterEmail().get());
        }
        return this.addAsSafeRepo(git);
    }

    protected @Nullable RepoState addAsSafeRepo(Git git) {
        if (!((Boolean)this.getAddAsSafeDirectory().get()).booleanValue()) {
            this.getLogger().info("Not adding submodules as safe directories due to configuration parameter being disabled");
            return null;
        }
        List<String> safeDirs = this.safeDirs(git);
        boolean hasPatched = safeDirs.contains(((Directory)this.getRepo().get()).getAsFile().getAbsolutePath());
        boolean hasUpstream = safeDirs.contains(((Directory)this.getSubmoduleRoot().get()).getAsFile().getAbsolutePath());
        if (!hasPatched) {
            git.config("--global", "--add", SAFE_DIRECTORY, ((Directory)this.getRepo().get()).getAsFile().getAbsolutePath()).expectSuccess();
        }
        if (!hasUpstream) {
            git.config("--global", "--add", SAFE_DIRECTORY, ((Directory)this.getSubmoduleRoot().get()).getAsFile().getAbsolutePath()).expectSuccess();
        }
        return new RepoState(hasUpstream, hasPatched);
    }

    protected void cleanUpSafeRepo(Git git, @Nullable RepoState state) {
        if (state == null) {
            return;
        }
        List<String> safeDirs = this.safeDirs(git);
        boolean changed = false;
        if (!state.hadPatched()) {
            safeDirs.remove(((Directory)this.getRepo().get()).getAsFile().getAbsolutePath());
            changed = true;
        }
        if (!state.hadUpstream()) {
            safeDirs.remove(((Directory)this.getSubmoduleRoot().get()).getAsFile().getAbsolutePath());
            changed = true;
        }
        if (changed) {
            git.config("--global", "--unset-all", SAFE_DIRECTORY).awaitCompletion();
            safeDirs.forEach(it -> git.config("--global", "--add", SAFE_DIRECTORY, (String)it).awaitCompletion());
        }
    }

    private List<String> safeDirs(Git git) {
        String safeDirs = git.config("--global", "--get-all", SAFE_DIRECTORY).forceGetText();
        return safeDirs == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(safeDirs.split("\n", -1)));
    }

    public record RepoState(boolean hadUpstream, boolean hadPatched) {
    }
}

