/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.gitpatcher.internal;

import ca.stellardrift.gitpatcher.internal.Git;
import ca.stellardrift.gitpatcher.internal.GitFactory;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.gradle.api.logging.Logger;

public class DefaultGitFactory
implements GitFactory {
    private final ExecutorService ioExecutor = Executors.newCachedThreadPool();

    @Override
    public Git create(Path path, Logger logger) {
        return new Git(path, this.ioExecutor, logger);
    }

    @Override
    public void close() {
        this.ioExecutor.shutdown();
        try {
            if (!this.ioExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.ioExecutor.shutdownNow();
            }
        }
        catch (InterruptedException ex) {
            this.ioExecutor.shutdownNow();
            throw new RuntimeException("Interrupted during shutdown");
        }
    }
}

