/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.gitpatcher.internal;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Locale;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class Utils {
    private Utils() {
    }

    public static String capitalize(String input) {
        switch (input.length()) {
            case 0: {
                return "";
            }
            case 1: {
                return input.toUpperCase(Locale.ROOT);
            }
        }
        StringBuilder ret = new StringBuilder(input.length());
        int firstCodePoint = input.codePointAt(0);
        ret.appendCodePoint(Character.toUpperCase(firstCodePoint));
        ret.append(input.substring(Character.charCount(firstCodePoint)));
        return ret.toString();
    }

    public static boolean deleteRecursively(Path dir) throws IOException {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            return false;
        }
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                throw exc;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, @Nullable IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
        return true;
    }

    public static boolean isEmptyDir(Path dir) throws IOException {
        try (Stream<Path> children = Files.list(dir);){
            boolean bl = children.findAny().isEmpty();
            return bl;
        }
    }
}

