/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.build.configurate;

import ca.stellardrift.build.configurate.ConfigProcessor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.gson.GsonConfigurationLoader;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.loader.AbstractConfigurationLoader;
import org.spongepowered.configurate.xml.XmlConfigurationLoader;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public final class ConfigFormats {
    private static final Map<String, ConfigProcessor<?, ?>> BY_EXTENSION = new HashMap();
    private static final Set<ConfigProcessor<?, ?>> PROCESSORS = new HashSet();
    public static final ConfigProcessor<HoconConfigurationLoader.Builder, HoconConfigurationLoader> HOCON = ConfigFormats.register(HoconConfigurationLoader::builder, "conf", "hocon");
    public static final ConfigProcessor<GsonConfigurationLoader.Builder, GsonConfigurationLoader> JSON = ConfigFormats.register(GsonConfigurationLoader::builder, "json");
    public static final ConfigProcessor<YamlConfigurationLoader.Builder, YamlConfigurationLoader> YAML = ConfigFormats.register(YamlConfigurationLoader::builder, "yml", "yaml");
    public static final ConfigProcessor<XmlConfigurationLoader.Builder, XmlConfigurationLoader> XML = ConfigFormats.register(XmlConfigurationLoader::builder, "xml");

    private ConfigFormats() {
    }

    private static <B extends AbstractConfigurationLoader.Builder<B, L>, L extends AbstractConfigurationLoader<?>> ConfigProcessor<B, L> register(Supplier<B> builder, String ... extensions) {
        ConfigProcessor ret = new ConfigProcessor(builder, extensions);
        PROCESSORS.add(ret);
        for (String ext : extensions) {
            BY_EXTENSION.put(ext, ret);
        }
        return ret;
    }

    public static Set<ConfigProcessor<?, ?>> all() {
        return Collections.unmodifiableSet(PROCESSORS);
    }

    public static @Nullable ConfigProcessor<?, ?> byExtension(String extension) {
        return BY_EXTENSION.get(extension);
    }
}

