/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.build.configurate.catalog;

import ca.stellardrift.build.configurate.catalog.ImmutableGradleVersion;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.immutables.value.Value;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

@Value.Immutable
@Value.Style(get={"*"}, jdkOnly=true, overshadowImplementation=true, visibility=Value.Style.ImplementationVisibility.PACKAGE)
interface GradleVersion {
    public static Builder builder() {
        return new Builder();
    }

    public @Nullable String versionRef();

    public @Nullable String require();

    public @Nullable String strictly();

    public @Nullable String prefer();

    public List<String> rejectedVersions();

    @Value.Default
    default public boolean rejectAll() {
        return false;
    }

    default public void applyTo(MutableVersionConstraint spec) {
        if (this.versionRef() != null) {
            throw new IllegalStateException("Cannot apply a version reference (" + this.versionRef() + ") to a normal constraint!");
        }
        if (this.require() != null) {
            spec.require(this.require());
        }
        if (this.strictly() != null) {
            spec.strictly(this.strictly());
        }
        if (this.prefer() != null) {
            spec.prefer(this.prefer());
        }
        if (!this.rejectedVersions().isEmpty()) {
            spec.reject(this.rejectedVersions().toArray(new String[0]));
        }
        if (this.rejectAll()) {
            spec.rejectAll();
        }
    }

    default public boolean complex() {
        return !this.rejectedVersions().isEmpty() || this.versionRef() != null || this.rejectAll() || this.require() != null && (this.prefer() != null || this.strictly() != null) || this.prefer() != null && this.strictly() == null;
    }

    public static class Serializer
    implements TypeSerializer<GradleVersion> {
        public static final Serializer INSTANCE = new Serializer();
        private static final String RICH_DELIMITER = "!!";
        private static final String VERSION_REF = "ref";
        private static final String REQUIRE = "require";
        private static final String PREFER = "prefer";
        private static final String STRICTLY = "strictly";
        private static final String REJECT = "reject";
        private static final String REJECT_ALL = "rejectAll";

        private Serializer() {
        }

        public GradleVersion deserialize(Type type, ConfigurationNode node) throws SerializationException {
            if (node.isList()) {
                throw new SerializationException("A version specification must be as either a String or a mapping of parameters");
            }
            Builder builder = new Builder();
            if (node.isMap()) {
                builder.versionRef(node.node(new Object[]{VERSION_REF}).getString()).require(node.node(new Object[]{REQUIRE}).getString()).prefer(node.node(new Object[]{PREFER}).getString()).strictly(node.node(new Object[]{STRICTLY}).getString()).addAllRejectedVersions(node.node(new Object[]{REJECT}).getList(String.class, Collections.emptyList())).rejectAll(node.node(new Object[]{REJECT_ALL}).getBoolean(false));
            } else {
                this.parsePlain(node.getString(), builder);
            }
            return builder.build();
        }

        private void parsePlain(String strictSpec, Builder builder) throws SerializationException {
            int delimiter = strictSpec.indexOf(RICH_DELIMITER);
            if (delimiter == 0) {
                throw new SerializationException(GradleVersion.class, "A strict version must be in the form <strict>!![preferred]");
            }
            if (delimiter == -1) {
                builder.require(strictSpec);
            } else {
                boolean hasPreferred = delimiter < strictSpec.length() - 2;
                builder.strictly(strictSpec.substring(0, delimiter));
                if (hasPreferred) {
                    builder.prefer(strictSpec.substring(delimiter + RICH_DELIMITER.length()));
                }
            }
        }

        public void serialize(Type type, @Nullable GradleVersion version, ConfigurationNode node) throws SerializationException {
            if (version == null) {
                node.raw(null);
                return;
            }
            if (node.isMap() || version.complex()) {
                node.node(new Object[]{VERSION_REF}).set((Object)version.versionRef());
                node.node(new Object[]{REQUIRE}).set((Object)version.require());
                node.node(new Object[]{PREFER}).set((Object)version.prefer());
                node.node(new Object[]{STRICTLY}).set((Object)version.strictly());
                List<String> rejected = version.rejectedVersions();
                if (rejected == null || rejected.isEmpty()) {
                    node.node(new Object[]{REJECT}).set(null);
                } else {
                    node.node(new Object[]{REJECT}).set(rejected);
                }
                node.node(new Object[]{REJECT_ALL}).set((Object)(version.rejectAll() ? Boolean.valueOf(true) : null));
            } else {
                @Nullable String require = version.require();
                @Nullable String prefer = version.prefer();
                @Nullable String strictly = version.strictly();
                if (require != null) {
                    node.set((Object)require);
                } else if (prefer != null) {
                    node.set((Object)(strictly + RICH_DELIMITER + prefer));
                } else {
                    node.set((Object)(strictly + RICH_DELIMITER));
                }
            }
        }
    }

    public static class Builder
    extends ImmutableGradleVersion.Builder {
    }
}

