/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.build.configurate.catalog;

import ca.stellardrift.build.configurate.GradleVersionUtil;
import ca.stellardrift.build.configurate.catalog.FormatExtension;
import ca.stellardrift.build.configurate.catalog.GradleVersion;
import ca.stellardrift.build.configurate.catalog.PolyglotVersionCatalogPlugin;
import io.leangen.geantyref.TypeFactory;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.initialization.dsl.VersionCatalogBuilder;
import org.gradle.plugin.use.PluginDependenciesSpec;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

final class VersionCatalogApplier {
    private static final String METADATA = "metadata";
    private static final String DEPENDENCIES = "dependencies";
    private static final String BUNDLES = "bundles";
    private static final String PLUGINS = "plugins";
    private static final String VERSIONS = "versions";
    private static final Type MAP_STRING_STRING = TypeFactory.parameterizedClass(Map.class, (Type[])new Type[]{String.class, String.class});
    private static final Type MAP_STRING_LIST_STRING = TypeFactory.parameterizedClass(Map.class, (Type[])new Type[]{String.class, TypeFactory.parameterizedClass(List.class, (Type[])new Type[]{String.class})});
    private static final Type MAP_STRING_GRADLEVERSION = TypeFactory.parameterizedClass(Map.class, (Type[])new Type[]{String.class, GradleVersion.class});
    private final VersionCatalogBuilder builder;
    private final PluginDependenciesSpec plugins;
    private final Set<FormatExtension> enabledExtensions = EnumSet.noneOf(FormatExtension.class);

    public VersionCatalogApplier(VersionCatalogBuilder builder, PluginDependenciesSpec plugins) {
        this.builder = builder;
        this.plugins = plugins;
    }

    public void load(ConfigurationNode node) throws SerializationException {
        ConfigurationNode versions;
        ConfigurationNode plugins;
        ConfigurationNode bundles;
        ConfigurationNode dependencies;
        ConfigurationNode metadata = node.node(new Object[]{METADATA});
        if (!metadata.empty()) {
            this.metadata(metadata);
        }
        if (!(dependencies = node.node(new Object[]{DEPENDENCIES})).empty()) {
            this.dependencies(dependencies);
        }
        if (!(bundles = node.node(new Object[]{BUNDLES})).empty()) {
            this.bundles(bundles);
        }
        if (this.enabledExtensions.contains((Object)FormatExtension.PLUGINS) && !(plugins = node.node(new Object[]{PLUGINS})).empty()) {
            this.plugins(plugins);
        }
        if (!(versions = node.node(new Object[]{VERSIONS})).empty()) {
            this.versions(versions);
        }
    }

    private void metadata(ConfigurationNode metadata) throws SerializationException {
        String formatVersion = metadata.node(new Object[]{"format", "version"}).getString();
        if (formatVersion != null && !formatVersion.equals(PolyglotVersionCatalogPlugin.FORMAT_VERSION)) {
            throw new SerializationException(metadata.parent(), VersionCatalogBuilder.class, "A version catalog was provided with format version " + formatVersion + " but the polyglot catalog plugin only understands version " + PolyglotVersionCatalogPlugin.FORMAT_VERSION);
        }
        this.enabledExtensions.addAll(metadata.node(new Object[]{"polyglot-extensions"}).getList(FormatExtension.class, Collections::emptyList));
    }

    private void dependencies(ConfigurationNode dependencies) throws SerializationException {
        if (!dependencies.isMap()) {
            throw new SerializationException(dependencies, Map.class, "Dependencies must be specified as a map of <alias> => <string or map>");
        }
        for (Map.Entry entry : dependencies.childrenMap().entrySet()) {
            String alias = String.valueOf(entry.getKey());
            ConfigurationNode dep = (ConfigurationNode)entry.getValue();
            if (dep.isMap()) {
                VersionCatalogBuilder.LibraryAliasBuilder build;
                @Nullable String group = dep.node(new Object[]{"group"}).getString();
                @Nullable String name = dep.node(new Object[]{"name"}).getString();
                if (name == null && dep.hasChild(new Object[]{"artifact"})) {
                    name = dep.node(new Object[]{"artifact"}).getString();
                }
                String moduleInfo = dep.node(new Object[]{"module"}).getString();
                @Nullable GradleVersion version = (GradleVersion)dep.node(new Object[]{"version"}).get(GradleVersion.class);
                if (group == null || name == null) {
                    if (moduleInfo == null) {
                        throw new SerializationException(dep, VersionCatalogBuilder.LibraryAliasBuilder.class, "Either group and name, or module fields must be specified for an alias!");
                    }
                    if (group != null || name != null) {
                        throw new SerializationException(dep, VersionCatalogBuilder.LibraryAliasBuilder.class, "If the 'module' key is used, the 'group' and 'name' fields cannot be specified as they are redundant.");
                    }
                    String[] elements = moduleInfo.split(":");
                    if (elements.length == 3 && version == null) {
                        this.library(alias, moduleInfo);
                        continue;
                    }
                    if (elements.length < 2) {
                        throw new SerializationException(dep, VersionCatalogBuilder.LibraryAliasBuilder.class, "A module specification must be in group:artifact[:version] format. To specify element separately, use the 'group' and 'name' keys in the map.");
                    }
                    build = this.library(alias, elements[0], elements[1]);
                } else {
                    build = this.library(alias, group, name);
                }
                if (version == null) {
                    build.withoutVersion();
                    continue;
                }
                @Nullable String versionRef = version.versionRef();
                if (versionRef != null) {
                    build.versionRef(versionRef);
                    continue;
                }
                build.version(version::applyTo);
                continue;
            }
            String gav = dep.getString();
            if (gav == null) {
                throw new SerializationException(dep, String.class, "Unable to get a String or Map value for a dependency");
            }
            this.library(alias, gav);
        }
    }

    private void library(String alias, String gav) {
        if (GradleVersionUtil.VERSION_CATALOGS_STABLE) {
            this.builder.library(alias, gav);
        } else {
            this.builder.alias(alias).to(gav);
        }
    }

    private VersionCatalogBuilder.LibraryAliasBuilder library(String alias, String group, String name) {
        if (GradleVersionUtil.VERSION_CATALOGS_STABLE) {
            return this.builder.library(alias, group, name);
        }
        return this.builder.alias(alias).to(group, name);
    }

    private void bundles(ConfigurationNode bundles) throws SerializationException {
        if (!bundles.isMap()) {
            throw new SerializationException(bundles, MAP_STRING_LIST_STRING, "Bundles must be specified as a map of <bundle name> => list of aliases");
        }
        for (Map.Entry entry : bundles.childrenMap().entrySet()) {
            this.builder.bundle(String.valueOf(entry.getKey()), ((ConfigurationNode)entry.getValue()).getList(String.class, Collections.emptyList()));
        }
    }

    private void plugins(ConfigurationNode plugins) throws SerializationException {
        if (!plugins.isMap()) {
            throw new SerializationException(plugins, MAP_STRING_STRING, "Plugins must be specified as a map of id => version");
        }
        for (Map.Entry entry : plugins.childrenMap().entrySet()) {
            this.plugins.id(String.valueOf(entry.getKey())).version((String)((ConfigurationNode)entry.getValue()).get(String.class));
        }
    }

    private void versions(ConfigurationNode versions) throws SerializationException {
        if (!versions.isMap()) {
            throw new SerializationException(versions, MAP_STRING_GRADLEVERSION, "Version references must be specified as a map of <ref id> => version specification");
        }
        for (Map.Entry entry : versions.childrenMap().entrySet()) {
            String reference = String.valueOf(entry.getKey());
            GradleVersion version = (GradleVersion)((ConfigurationNode)entry.getValue()).get(GradleVersion.class);
            if (version == null) {
                throw new SerializationException((ConfigurationNode)entry.getValue(), GradleVersion.class, "Must have a non-null version value");
            }
            if (version.versionRef() != null) {
                throw new SerializationException((ConfigurationNode)entry.getValue(), GradleVersion.class, "Version reference cannot point to another reference");
            }
            try {
                this.builder.version(reference, version::applyTo);
            }
            catch (InvalidUserDataException ex) {
                throw new SerializationException((ConfigurationNode)entry.getValue(), GradleVersion.class, ex.getMessage(), ex.getCause());
            }
        }
    }
}

