/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.build.configurate.transformations;

import ca.stellardrift.build.configurate.ConfigSource;
import ca.stellardrift.build.configurate.ConfigTarget;
import ca.stellardrift.build.configurate.transformations.TrustedByteArrayOutput;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.gradle.api.Action;
import org.spongepowered.configurate.ConfigurationNode;

public class ConfigurateFilterReader
extends FilterReader {
    public static final String PARAM_SOURCE = "source";
    public static final String PARAM_DEST = "dest";
    public static final String PARAM_TRANSFORMER = "transformer";
    private final Reader original;
    private @MonotonicNonNull ConfigSource source;
    private @MonotonicNonNull ConfigTarget dest;
    private @Nullable Action<ConfigurationNode> transformer;
    private boolean setUp = false;

    public ConfigurateFilterReader(@NonNull Reader in) {
        super(in);
        this.original = in;
    }

    public void source(ConfigSource source) {
        this.source = Objects.requireNonNull(source, PARAM_SOURCE);
    }

    public void dest(ConfigTarget dest) {
        this.dest = Objects.requireNonNull(dest, PARAM_DEST);
    }

    public void transformer(Action<ConfigurationNode> func) {
        this.transformer = func;
    }

    private void transformIfSetUp() throws IOException {
        if (!this.setUp && this.source != null && this.dest != null) {
            this.setUp = true;
            ConfigurationNode node = this.source.read(this.in);
            if (this.transformer != null) {
                this.transformer.execute((Object)node);
            }
            TrustedByteArrayOutput holder = new TrustedByteArrayOutput();
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)holder, StandardCharsets.UTF_8);){
                this.dest.write(writer, node);
            }
            this.in = new InputStreamReader(holder.toInputStream(), StandardCharsets.UTF_8);
        }
    }

    private void requireSetUp() throws IOException {
        if (!this.setUp) {
            this.transformIfSetUp();
            if (!this.setUp) {
                throw new IllegalStateException("Resource transformer has not received required source and dest loaders!");
            }
        }
    }

    @Override
    public int read() throws IOException {
        this.requireSetUp();
        return super.read();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.requireSetUp();
        return super.read(cbuf, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        this.requireSetUp();
        return super.skip(n);
    }

    @Override
    public boolean ready() throws IOException {
        this.requireSetUp();
        return super.ready();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.requireSetUp();
        super.mark(readAheadLimit);
    }

    @Override
    public void reset() throws IOException {
        this.requireSetUp();
        super.reset();
    }

    @Override
    public void close() throws IOException {
        if (this.in != this.original) {
            this.original.close();
        }
        super.close();
    }
}

