/*
 * Copyright 2020 zml
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ca.stellardrift.build.configurate.transformations;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

/**
 * A [ByteArrayOutputStream] that directly exposes its buffer,
 * so we can use a [ByteArrayInputStream] without requiring a copy
 */
class TrustedByteArrayOutput extends ByteArrayOutputStream {

    /**
     * Get a new input stream reading from this stream's buffer.
     *
     * @return the new stream
     */
    InputStream toInputStream() {
        return new ByteArrayInputStream(this.buf, 0, this.count);
    }

}

