/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.build.configurate.catalog;

import ca.stellardrift.build.configurate.ConfigSource;
import ca.stellardrift.build.configurate.catalog.GradleVersion;
import ca.stellardrift.build.configurate.catalog.VersionCatalogApplier;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.initialization.Settings;
import org.gradle.api.initialization.dsl.VersionCatalogBuilder;
import org.gradle.api.initialization.resolve.MutableVersionCatalogContainer;
import org.gradle.plugin.use.PluginDependenciesSpec;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

public abstract class PolyglotVersionCatalogExtension {
    private final Settings settings;

    public PolyglotVersionCatalogExtension(Settings settings) {
        this.settings = settings;
    }

    public void from(ConfigSource source, File file) {
        this.from(source, file.toPath());
    }

    public void from(ConfigSource source, Path file) {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(file, "file");
        this.populateCatalog((String)this.settings.getDependencyResolutionManagement().getDefaultLibrariesExtensionName().get(), source, file);
    }

    public void populateCatalog(String versionCatalog, ConfigSource source, File file) {
        this.populateCatalog(versionCatalog, source, file.toPath());
    }

    public void populateCatalog(String versionCatalog, ConfigSource source, Path file) {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(file, "file");
        PluginDependenciesSpec plugins = this.settings.getPluginManagement().getPlugins();
        MutableVersionCatalogContainer catalogs = this.settings.getDependencyResolutionManagement().getVersionCatalogs();
        if (catalogs.getNames().contains(versionCatalog)) {
            catalogs.named(versionCatalog, (Action)new VersionCatalogBuilderConfigurationAction(source, file, plugins));
        } else {
            catalogs.register(versionCatalog, (Action)new VersionCatalogBuilderConfigurationAction(source, file, plugins));
        }
    }

    public void populateCatalog(VersionCatalogBuilder versionCatalog, ConfigSource source, File file) {
        this.populateCatalog(versionCatalog, source, file.toPath());
    }

    public void populateCatalog(VersionCatalogBuilder versionCatalog, ConfigSource source, Path file) {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(file, "file");
        PluginDependenciesSpec plugins = this.settings.getPluginManagement().getPlugins();
        new VersionCatalogBuilderConfigurationAction(source, file, plugins).execute(versionCatalog);
    }

    static class VersionCatalogBuilderConfigurationAction
    implements Action<VersionCatalogBuilder> {
        private final ConfigSource source;
        private final Path file;
        private final PluginDependenciesSpec plugins;

        VersionCatalogBuilderConfigurationAction(ConfigSource source, Path file, PluginDependenciesSpec plugins) {
            this.source = source;
            this.file = file;
            this.plugins = plugins;
        }

        public void execute(@NonNull VersionCatalogBuilder builder) {
            VersionCatalogApplier app = new VersionCatalogApplier(builder, this.plugins);
            try (BufferedReader reader = Files.newBufferedReader(this.file, StandardCharsets.UTF_8);){
                ConfigurationNode node = this.source.read(reader, opts -> opts.serializers(serializers -> serializers.register(GradleVersion.class, (TypeSerializer)GradleVersion.Serializer.INSTANCE)));
                app.load(node);
            }
            catch (SerializationException ex) {
                throw new InvalidUserDataException(ex.getMessage(), (Throwable)ex);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to read versions catalog", ex);
            }
        }
    }
}

