/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.build.configurate.catalog;

import ca.stellardrift.build.configurate.ConfigFormats;
import ca.stellardrift.build.configurate.ConfigProcessor;
import ca.stellardrift.build.configurate.GradleVersionUtil;
import ca.stellardrift.build.configurate.catalog.PolyglotVersionCatalogExtension;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.gradle.api.Plugin;
import org.gradle.api.initialization.Settings;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class PolyglotVersionCatalogPlugin
implements Plugin<Settings> {
    public static final String FORMAT_VERSION = "1.0";
    private static final Logger LOGGER = Logging.getLogger(PolyglotVersionCatalogPlugin.class);
    private static final String DEPENDENCIES_FILE_NAME = "libs.versions";

    public void apply(Settings target) {
        PolyglotVersionCatalogExtension deps = (PolyglotVersionCatalogExtension)target.getExtensions().create("deps", PolyglotVersionCatalogExtension.class, new Object[]{target});
        if (!GradleVersionUtil.VERSION_CATALOGS_STABLE) {
            target.enableFeaturePreview("VERSION_CATALOGS");
        }
        target.getGradle().settingsEvaluated(settings -> {
            Path gradleDir = settings.getRootDir().toPath().resolve("gradle");
            for (ConfigProcessor<?, ?> processor : ConfigFormats.all()) {
                for (String extension : processor.extensions()) {
                    Path candidate = gradleDir.resolve("libs.versions." + extension);
                    if (!Files.exists(candidate, new LinkOption[0])) continue;
                    LOGGER.info("Chose file {} for dependencies manifest", (Object)candidate);
                    deps.from(processor, candidate);
                    return;
                }
            }
        });
    }
}

