/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.build.configurate.transformations;

import ca.stellardrift.build.configurate.ConfigSource;
import ca.stellardrift.build.configurate.transformations.TrustedByteArrayOutput;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ConfigurateValidationReader
extends FilterReader {
    public static final String PARAM_FORMAT = "format";
    private final Reader original;

    public ConfigurateValidationReader(@NonNull Reader in) {
        super(in);
        this.original = in;
    }

    public void format(ConfigSource format) throws IOException {
        TrustedByteArrayOutput output = new TrustedByteArrayOutput();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, StandardCharsets.UTF_8);){
            char[] buffer = new char[2048];
            int read = this.original.read(buffer);
            while (read != -1) {
                writer.write(buffer, 0, read);
                read = this.original.read(buffer);
            }
        }
        try (InputStreamReader reader = new InputStreamReader(output.toInputStream(), StandardCharsets.UTF_8);){
            format.read(reader);
        }
        this.in = new InputStreamReader(output.toInputStream());
    }
}

