/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.build.configurate;

import ca.stellardrift.build.configurate.ConfigSource;
import ca.stellardrift.build.configurate.ConfigTarget;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.gradle.api.Action;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.loader.AbstractConfigurationLoader;
import org.spongepowered.configurate.util.UnmodifiableCollections;

public final class ConfigProcessor<B extends AbstractConfigurationLoader.Builder<B, L>, L extends AbstractConfigurationLoader<?>>
implements ConfigSource,
ConfigTarget {
    private final Supplier<B> builderMaker;
    private final Set<String> extensions;

    ConfigProcessor(Supplier<B> builderMaker, String ... extensions) {
        this.builderMaker = Objects.requireNonNull(builderMaker);
        this.extensions = UnmodifiableCollections.toSet((Object[])extensions);
    }

    private ConfigProcessor(Supplier<B> builderMaker, Set<String> extensions) {
        this.builderMaker = Objects.requireNonNull(builderMaker);
        this.extensions = extensions;
    }

    @Override
    public ConfigurationNode read(Reader reader) throws ConfigurateException {
        Objects.requireNonNull(reader, "reader");
        AbstractConfigurationLoader loader = ((AbstractConfigurationLoader.Builder)this.builderMaker.get()).source(() -> new BufferedReader(reader)).build();
        return loader.load();
    }

    @Override
    public ConfigurationNode read(Reader reader, UnaryOperator<ConfigurationOptions> optionsModifier) throws ConfigurateException {
        Objects.requireNonNull(reader, "reader");
        AbstractConfigurationLoader loader = ((AbstractConfigurationLoader.Builder)this.builderMaker.get()).defaultOptions(optionsModifier).source(() -> new BufferedReader(reader)).build();
        return loader.load();
    }

    @Override
    public void write(Writer destination, ConfigurationNode node) throws ConfigurateException {
        Objects.requireNonNull(destination, "destination");
        Objects.requireNonNull(node, "node");
        AbstractConfigurationLoader loader = ((AbstractConfigurationLoader.Builder)this.builderMaker.get()).sink(() -> new BufferedWriter(destination)).build();
        loader.save(node);
    }

    public ConfigProcessor<B, L> configured(Action<B> builderModifier) {
        Objects.requireNonNull(builderModifier, "builderModifier");
        return new ConfigProcessor<AbstractConfigurationLoader.Builder, L>(() -> {
            AbstractConfigurationLoader.Builder ret = (AbstractConfigurationLoader.Builder)this.builderMaker.get();
            builderModifier.execute((Object)ret);
            return ret;
        }, this.extensions);
    }

    public Set<String> extensions() {
        return this.extensions;
    }
}

