/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.build.configurate.catalog;

import ca.stellardrift.build.configurate.catalog.GradleVersion;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GradleVersion", generator="Immutables")
@Immutable
final class ImmutableGradleVersion
implements GradleVersion {
    private final @org.checkerframework.checker.nullness.qual.Nullable String versionRef;
    private final @org.checkerframework.checker.nullness.qual.Nullable String require;
    private final @org.checkerframework.checker.nullness.qual.Nullable String strictly;
    private final @org.checkerframework.checker.nullness.qual.Nullable String prefer;
    private final List<String> rejectedVersions;
    private final boolean rejectAll;

    private ImmutableGradleVersion(Builder builder) {
        this.versionRef = builder.versionRef;
        this.require = builder.require;
        this.strictly = builder.strictly;
        this.prefer = builder.prefer;
        this.rejectedVersions = ImmutableGradleVersion.createUnmodifiableList(true, builder.rejectedVersions);
        this.rejectAll = builder.rejectAllIsSet() ? builder.rejectAll : GradleVersion.super.rejectAll();
    }

    private ImmutableGradleVersion(@org.checkerframework.checker.nullness.qual.Nullable String versionRef, @org.checkerframework.checker.nullness.qual.Nullable String require, @org.checkerframework.checker.nullness.qual.Nullable String strictly, @org.checkerframework.checker.nullness.qual.Nullable String prefer, List<String> rejectedVersions, boolean rejectAll) {
        this.versionRef = versionRef;
        this.require = require;
        this.strictly = strictly;
        this.prefer = prefer;
        this.rejectedVersions = rejectedVersions;
        this.rejectAll = rejectAll;
    }

    @Override
    public @org.checkerframework.checker.nullness.qual.Nullable String versionRef() {
        return this.versionRef;
    }

    @Override
    public @org.checkerframework.checker.nullness.qual.Nullable String require() {
        return this.require;
    }

    @Override
    public @org.checkerframework.checker.nullness.qual.Nullable String strictly() {
        return this.strictly;
    }

    @Override
    public @org.checkerframework.checker.nullness.qual.Nullable String prefer() {
        return this.prefer;
    }

    @Override
    public List<String> rejectedVersions() {
        return this.rejectedVersions;
    }

    @Override
    public boolean rejectAll() {
        return this.rejectAll;
    }

    public final ImmutableGradleVersion withVersionRef(@org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.versionRef, value)) {
            return this;
        }
        return new ImmutableGradleVersion(value, this.require, this.strictly, this.prefer, this.rejectedVersions, this.rejectAll);
    }

    public final ImmutableGradleVersion withRequire(@org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.require, value)) {
            return this;
        }
        return new ImmutableGradleVersion(this.versionRef, value, this.strictly, this.prefer, this.rejectedVersions, this.rejectAll);
    }

    public final ImmutableGradleVersion withStrictly(@org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.strictly, value)) {
            return this;
        }
        return new ImmutableGradleVersion(this.versionRef, this.require, value, this.prefer, this.rejectedVersions, this.rejectAll);
    }

    public final ImmutableGradleVersion withPrefer(@org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.prefer, value)) {
            return this;
        }
        return new ImmutableGradleVersion(this.versionRef, this.require, this.strictly, value, this.rejectedVersions, this.rejectAll);
    }

    public final ImmutableGradleVersion withRejectedVersions(String ... elements) {
        List<String> newValue = ImmutableGradleVersion.createUnmodifiableList(false, ImmutableGradleVersion.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGradleVersion(this.versionRef, this.require, this.strictly, this.prefer, newValue, this.rejectAll);
    }

    public final ImmutableGradleVersion withRejectedVersions(Iterable<String> elements) {
        if (this.rejectedVersions == elements) {
            return this;
        }
        List<String> newValue = ImmutableGradleVersion.createUnmodifiableList(false, ImmutableGradleVersion.createSafeList(elements, true, false));
        return new ImmutableGradleVersion(this.versionRef, this.require, this.strictly, this.prefer, newValue, this.rejectAll);
    }

    public final ImmutableGradleVersion withRejectAll(boolean value) {
        if (this.rejectAll == value) {
            return this;
        }
        return new ImmutableGradleVersion(this.versionRef, this.require, this.strictly, this.prefer, this.rejectedVersions, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGradleVersion && this.equalTo(0, (ImmutableGradleVersion)another);
    }

    private boolean equalTo(int synthetic, ImmutableGradleVersion another) {
        return Objects.equals(this.versionRef, another.versionRef) && Objects.equals(this.require, another.require) && Objects.equals(this.strictly, another.strictly) && Objects.equals(this.prefer, another.prefer) && this.rejectedVersions.equals(another.rejectedVersions) && this.rejectAll == another.rejectAll;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.versionRef);
        h += (h << 5) + Objects.hashCode(this.require);
        h += (h << 5) + Objects.hashCode(this.strictly);
        h += (h << 5) + Objects.hashCode(this.prefer);
        h += (h << 5) + this.rejectedVersions.hashCode();
        h += (h << 5) + Boolean.hashCode(this.rejectAll);
        return h;
    }

    public String toString() {
        return "GradleVersion{versionRef=" + this.versionRef + ", require=" + this.require + ", strictly=" + this.strictly + ", prefer=" + this.prefer + ", rejectedVersions=" + this.rejectedVersions + ", rejectAll=" + this.rejectAll + "}";
    }

    public static GradleVersion copyOf(GradleVersion instance) {
        if (instance instanceof ImmutableGradleVersion) {
            return (ImmutableGradleVersion)instance;
        }
        return new GradleVersion.Builder().from(instance).build();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="GradleVersion", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long OPT_BIT_REJECT_ALL = 1L;
        private long optBits;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String versionRef;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String require;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String strictly;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String prefer;
        private List<String> rejectedVersions = new ArrayList<String>();
        private boolean rejectAll;

        public Builder() {
            if (!(this instanceof GradleVersion.Builder)) {
                throw new UnsupportedOperationException("Use: new GradleVersion.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final GradleVersion.Builder from(GradleVersion instance) {
            String preferValue;
            String strictlyValue;
            String requireValue;
            Objects.requireNonNull(instance, "instance");
            @org.checkerframework.checker.nullness.qual.Nullable String versionRefValue = instance.versionRef();
            if (versionRefValue != null) {
                this.versionRef(versionRefValue);
            }
            if ((requireValue = instance.require()) != null) {
                this.require(requireValue);
            }
            if ((strictlyValue = instance.strictly()) != null) {
                this.strictly(strictlyValue);
            }
            if ((preferValue = instance.prefer()) != null) {
                this.prefer(preferValue);
            }
            this.addAllRejectedVersions(instance.rejectedVersions());
            this.rejectAll(instance.rejectAll());
            return (GradleVersion.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GradleVersion.Builder versionRef(@org.checkerframework.checker.nullness.qual.Nullable String versionRef) {
            this.versionRef = versionRef;
            return (GradleVersion.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GradleVersion.Builder require(@org.checkerframework.checker.nullness.qual.Nullable String require) {
            this.require = require;
            return (GradleVersion.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GradleVersion.Builder strictly(@org.checkerframework.checker.nullness.qual.Nullable String strictly) {
            this.strictly = strictly;
            return (GradleVersion.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GradleVersion.Builder prefer(@org.checkerframework.checker.nullness.qual.Nullable String prefer) {
            this.prefer = prefer;
            return (GradleVersion.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GradleVersion.Builder addRejectedVersions(String element) {
            this.rejectedVersions.add(Objects.requireNonNull(element, "rejectedVersions element"));
            return (GradleVersion.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GradleVersion.Builder addRejectedVersions(String ... elements) {
            for (String element : elements) {
                this.rejectedVersions.add(Objects.requireNonNull(element, "rejectedVersions element"));
            }
            return (GradleVersion.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GradleVersion.Builder rejectedVersions(Iterable<String> elements) {
            this.rejectedVersions.clear();
            return this.addAllRejectedVersions(elements);
        }

        @CanIgnoreReturnValue
        public final GradleVersion.Builder addAllRejectedVersions(Iterable<String> elements) {
            for (String element : elements) {
                this.rejectedVersions.add(Objects.requireNonNull(element, "rejectedVersions element"));
            }
            return (GradleVersion.Builder)this;
        }

        @CanIgnoreReturnValue
        public final GradleVersion.Builder rejectAll(boolean rejectAll) {
            this.rejectAll = rejectAll;
            this.optBits |= 1L;
            return (GradleVersion.Builder)this;
        }

        public GradleVersion build() {
            return new ImmutableGradleVersion(this);
        }

        private boolean rejectAllIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

