/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.datastore;

import ca.stellardrift.permissionsex.context.ContextInheritance;
import ca.stellardrift.permissionsex.rank.RankLadder;
import ca.stellardrift.permissionsex.subject.ImmutableSubjectData;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.subject.SubjectType;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.util.UnmodifiableCollections;

public interface DataStore {
    public String name();

    public boolean firstRun();

    public void close();

    public CompletableFuture<ImmutableSubjectData> getData(String var1, String var2, @Nullable Consumer<ImmutableSubjectData> var3);

    default public CompletableFuture<ImmutableSubjectData> getData(SubjectRef<?> subject, @Nullable Consumer<ImmutableSubjectData> listener) {
        return this.getData(subject.type().name(), subject.serializedIdentifier(), listener);
    }

    public CompletableFuture<ImmutableSubjectData> setData(String var1, String var2, @Nullable ImmutableSubjectData var3);

    default public CompletableFuture<ImmutableSubjectData> setData(SubjectRef<?> subject, @Nullable ImmutableSubjectData data) {
        return this.setData(subject.type().name(), subject.serializedIdentifier(), data);
    }

    public CompletableFuture<Void> moveData(String var1, String var2, String var3, String var4);

    default public CompletableFuture<Void> moveData(SubjectRef<?> from, SubjectRef<?> to) {
        return this.moveData(from.type().name(), from.serializedIdentifier(), to.type().name(), to.serializedIdentifier());
    }

    public CompletableFuture<Boolean> isRegistered(String var1, String var2);

    default public CompletableFuture<Boolean> isRegistered(SubjectRef<?> subject) {
        return this.isRegistered(subject.type().name(), subject.serializedIdentifier());
    }

    public Stream<Map.Entry<String, ImmutableSubjectData>> getAll(String var1);

    default public <I> Stream<Map.Entry<I, ImmutableSubjectData>> getAll(SubjectType<I> type) {
        return this.getAll(type.name()).map(entry -> UnmodifiableCollections.immutableMapEntry(type.parseIdentifier((String)entry.getKey()), (Object)((ImmutableSubjectData)entry.getValue())));
    }

    public Stream<String> getAllIdentifiers(String var1);

    public Set<String> getRegisteredTypes();

    public CompletableFuture<Set<String>> getDefinedContextKeys();

    public Stream<Map.Entry<SubjectRef<?>, ImmutableSubjectData>> getAll();

    public <T> CompletableFuture<T> performBulkOperation(Function<DataStore, T> var1);

    public Stream<String> getAllRankLadders();

    public CompletableFuture<RankLadder> getRankLadder(String var1, @Nullable Consumer<RankLadder> var2);

    public CompletableFuture<Boolean> hasRankLadder(String var1);

    public CompletableFuture<RankLadder> setRankLadder(String var1, @Nullable RankLadder var2);

    public CompletableFuture<ContextInheritance> getContextInheritance(@Nullable Consumer<ContextInheritance> var1);

    public CompletableFuture<ContextInheritance> setContextInheritance(ContextInheritance var1);
}

