/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.datastore;

import ca.stellardrift.permissionsex.datastore.DataStoreFactory;
import java.util.Locale;
import java.util.Objects;
import java.util.ServiceLoader;
import org.pcollections.HashPMap;
import org.pcollections.HashTreePMap;
import org.pcollections.PMap;

class DataStoreFactories {
    private static final ServiceLoader<DataStoreFactory> LOADER = ServiceLoader.load(DataStoreFactory.class, DataStoreFactory.class.getClassLoader());
    static final PMap<String, DataStoreFactory<?>> REGISTRY;

    private DataStoreFactories() {
    }

    static {
        HashPMap factories = HashTreePMap.empty();
        for (DataStoreFactory factory : LOADER) {
            factories = factories.plus((Object)Objects.requireNonNull(factory.name(), () -> "Factory in class " + factory.getClass() + " had a null name()").toLowerCase(Locale.ROOT), (Object)factory);
        }
        REGISTRY = factories;
    }
}

