/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.context;

import ca.stellardrift.permissionsex.context.ContextDefinition;
import ca.stellardrift.permissionsex.subject.CalculatedSubject;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.HashTreePSet;

public abstract class EnumContextDefinition<T extends Enum<T>>
extends ContextDefinition<T> {
    private final Class<T> enumClass;
    private final Set<T> values;

    protected EnumContextDefinition(String name, Class<T> enumClass) {
        super(name);
        this.enumClass = enumClass;
        assert (this.enumClass.isEnum());
        this.values = HashTreePSet.from(Arrays.asList((Enum[])this.enumClass.getEnumConstants()));
    }

    @Override
    public final String serialize(T canonicalValue) {
        return ((Enum)canonicalValue).name();
    }

    @Override
    public final @Nullable T deserialize(String userValue) {
        try {
            return Enum.valueOf(this.enumClass, userValue.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    @Override
    public boolean matches(T ownVal, T testVal) {
        return ownVal == testVal;
    }

    @Override
    public void accumulateCurrentValues(CalculatedSubject subject, Consumer<T> consumer) {
    }

    @Override
    public Set<T> suggestValues(CalculatedSubject subject) {
        return this.values;
    }
}

