/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.subject;

import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.subject.SubjectType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface Segment {
    public static final int PERMISSION_UNSET = 0;

    public Map<String, String> options();

    public Segment withOption(String var1, String var2);

    public Segment withoutOption(String var1);

    public Segment withOptions(Map<String, String> var1);

    default public Segment withoutOptions() {
        return this.withOptions(Collections.emptyMap());
    }

    public Map<String, Integer> permissions();

    public Segment withPermission(String var1, int var2);

    public Segment withPermissions(Map<String, Integer> var1);

    public Segment withoutPermissions();

    public List<? extends SubjectRef<?>> parents();

    default public <I> Segment plusParent(SubjectType<I> type, I identifier) {
        return this.plusParent(SubjectRef.subject(type, identifier));
    }

    public <I> Segment plusParent(SubjectRef<I> var1);

    default public <I> Segment minusParent(SubjectType<I> type, I identifier) {
        return this.minusParent(SubjectRef.subject(type, identifier));
    }

    public <I> Segment minusParent(SubjectRef<I> var1);

    public Segment withParents(List<SubjectRef<?>> var1);

    public Segment withoutParents();

    public int fallbackPermission();

    public Segment withFallbackPermission(int var1);

    public Segment cleared();

    public boolean empty();

    default public Segment mergeFrom(Segment other) {
        if (other.empty()) {
            return this;
        }
        if (this.empty()) {
            return other;
        }
        Segment output = this;
        Map<String, Integer> permissions = other.permissions();
        Map<String, String> options = other.options();
        List<SubjectRef<?>> parents = other.parents();
        if (!permissions.isEmpty()) {
            HashMap<String, Integer> newPermissions = new HashMap<String, Integer>(output.permissions());
            newPermissions.putAll(permissions);
            output = output.withPermissions(newPermissions);
        }
        if (!options.isEmpty()) {
            HashMap<String, String> newOptions = new HashMap<String, String>(output.options());
            newOptions.putAll(options);
            output = output.withOptions(newOptions);
        }
        if (!parents.isEmpty()) {
            ArrayList newParents = new ArrayList(output.parents());
            newParents.addAll(parents);
            output = output.withParents(newParents);
        }
        return output;
    }
}

