/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.util;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class NodeTree {
    public static final int PERMISSION_UNDEFINED = 0;
    private static final Pattern SPLIT_REGEX = Pattern.compile("\\.");
    private final Node rootNode;

    private NodeTree(int value) {
        this.rootNode = new Node(new HashMap<String, Node>());
        this.rootNode.value = value;
    }

    private NodeTree(Node rootNode) {
        this.rootNode = rootNode;
    }

    public static NodeTree of(Map<String, Integer> values) {
        return NodeTree.of(values, 0);
    }

    public static NodeTree of(Map<String, Integer> values, int defaultValue) {
        NodeTree newTree = new NodeTree(defaultValue);
        for (Map.Entry<String, Integer> value : values.entrySet()) {
            String[] parts = NodeTree.splitPerm(value.getKey());
            Node currentNode = newTree.rootNode;
            for (String part : parts) {
                if (currentNode.children.containsKey(part)) {
                    currentNode = currentNode.children.get(part);
                    continue;
                }
                Node newNode = new Node();
                currentNode.putChild(part, newNode);
                currentNode = newNode;
            }
            currentNode.value = value.getValue();
        }
        return newTree;
    }

    public int get(String node) {
        String[] parts = NodeTree.splitPerm(node);
        Node currentNode = this.rootNode;
        int lastUndefinedVal = this.rootNode.value;
        for (String part : parts) {
            if (!currentNode.children.containsKey(part)) break;
            currentNode = currentNode.children.get(part);
            if (Math.abs(currentNode.value) < Math.abs(lastUndefinedVal)) continue;
            lastUndefinedVal = currentNode.value;
        }
        return lastUndefinedVal;
    }

    public boolean anyInPrefixMatching(String prefix, IntPredicate test) {
        Node current;
        String[] parts = NodeTree.splitPerm(prefix);
        Node currentNode = this.rootNode;
        int lastUndefinedVal = this.rootNode.value;
        for (String part : parts) {
            if (!currentNode.children.containsKey(part)) {
                return test.test(lastUndefinedVal);
            }
            currentNode = currentNode.children.get(part);
            if (Math.abs(currentNode.value) < Math.abs(lastUndefinedVal)) continue;
            lastUndefinedVal = currentNode.value;
        }
        if (currentNode.children.isEmpty()) {
            return test.test(lastUndefinedVal);
        }
        ArrayDeque<Node> toVisit = new ArrayDeque<Node>(currentNode.children.size() * 2);
        toVisit.addAll(currentNode.children.values());
        while ((current = (Node)toVisit.poll()) != null) {
            if (Math.abs(current.value) >= Math.abs(lastUndefinedVal) && test.test(current.value)) {
                return true;
            }
            toVisit.addAll(current.children.values());
        }
        return false;
    }

    public Map<String, Integer> asMap() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        for (Map.Entry<String, Node> ent : this.rootNode.children.entrySet()) {
            this.populateMap(ret, ent.getKey(), ent.getValue());
        }
        return Collections.unmodifiableMap(ret);
    }

    private void populateMap(Map<String, Integer> values, String prefix, Node currentNode) {
        if (currentNode.value != 0) {
            values.put(prefix, currentNode.value);
        }
        for (Map.Entry<String, Node> ent : currentNode.children.entrySet()) {
            this.populateMap(values, prefix + '.' + ent.getKey(), ent.getValue());
        }
    }

    public NodeTree withValue(String node, int value) {
        Node newRoot;
        String[] parts = NodeTree.splitPerm(node);
        Node newPtr = newRoot = new Node(new HashMap<String, Node>(this.rootNode.children));
        @Nullable Node currentPtr = this.rootNode;
        newPtr.value = currentPtr.value;
        for (String part : parts) {
            @Nullable Node oldChild = currentPtr == null ? null : currentPtr.children.get(part);
            Node newChild = new Node((Map<String, Node>)(oldChild != null ? new HashMap<String, Node>(oldChild.children) : new HashMap()));
            newPtr.children.put(part, newChild);
            currentPtr = oldChild;
            newPtr = newChild;
        }
        newPtr.value = value;
        return new NodeTree(newRoot);
    }

    public NodeTree withAll(Map<String, Integer> values) {
        NodeTree ret = this;
        for (Map.Entry<String, Integer> ent : values.entrySet()) {
            ret = ret.withValue(ent.getKey(), ent.getValue());
        }
        return ret;
    }

    public String toString() {
        return "NodeTree{" + this.rootNode + "}";
    }

    private static String[] splitPerm(String input) {
        Objects.requireNonNull(input, "input");
        return SPLIT_REGEX.split(input.toLowerCase(Locale.ROOT), -1);
    }

    static class Node {
        private static final Map<String, Node> EMPTY = Collections.emptyMap();
        Map<String, Node> children;
        int value = 0;

        Node(Map<String, Node> children) {
            this.children = children;
        }

        Node() {
            this.children = EMPTY;
        }

        void putChild(String path, Node child) {
            if (this.children == EMPTY) {
                this.children = new HashMap<String, Node>();
            }
            this.children.put(path, child);
        }

        public String toString() {
            return "<value: " + this.value + ", children=" + this.children + ">";
        }
    }
}

