/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.util;

import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.TranslationRegistry;
import net.kyori.adventure.translation.Translator;
import net.kyori.adventure.util.UTF8ResourceBundleControl;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TranslatableProvider
implements ComponentLike {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"PermissionsEx Translations");
    private static final String EXPECTED_EXTENSION = ".properties";
    private static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private static final Pattern SINGLE_QUOTE_PATTERN = Pattern.compile("'");
    private static @Nullable Path lastCodeSource;
    private static @Nullable Set<String> lastKnownResourceBundles;
    private final String key;

    public TranslatableProvider(String bundle, String key) {
        Objects.requireNonNull(bundle, "bundle");
        Objects.requireNonNull(key, "key");
        this.key = bundle + '/' + key;
    }

    public String key() {
        return this.key;
    }

    public TranslatableComponent tr(Object ... args) {
        return Component.translatable((String)this.key, (ComponentLike[])this.transformArray(args));
    }

    public TranslatableComponent.Builder bTr(Object ... args) {
        return Component.translatable().key(this.key).args((ComponentLike[])this.transformArray(args));
    }

    private Component[] transformArray(Object[] input) {
        Component[] output = new Component[input.length];
        int length = input.length;
        for (int i = 0; i < length; ++i) {
            output[i] = this.asComponent(input[i]);
        }
        return output;
    }

    private Component asComponent(Object input) {
        if (input instanceof Component) {
            return (Component)input;
        }
        if (input instanceof ComponentLike) {
            return ((ComponentLike)input).asComponent();
        }
        return Component.text((String)String.valueOf(input));
    }

    public @NonNull Component asComponent() {
        return this.tr(new Object[0]);
    }

    public static synchronized Stream<Locale> knownLocales(Class<?> loaderOf, String bundleName) {
        try {
            Set<String> paths;
            int exclamationIdx;
            URL sourceUrl = loaderOf.getProtectionDomain().getCodeSource().getLocation();
            if (sourceUrl.getProtocol().equals("jar") && (exclamationIdx = sourceUrl.getPath().lastIndexOf(33)) != -1) {
                sourceUrl = new URL(sourceUrl.getPath().substring(0, exclamationIdx));
            }
            Path codeSource = Paths.get(sourceUrl.toURI());
            String bundlePathName = bundleName.replace('.', '/');
            if (!codeSource.equals(lastCodeSource)) {
                String fileName = codeSource.getFileName().toString();
                if (Files.isDirectory(codeSource, new LinkOption[0])) {
                    try (Stream<Path> files = Files.walk(codeSource, new FileVisitOption[0]);){
                        paths = files.filter(it -> it.endsWith(EXPECTED_EXTENSION)).map(it -> it.relativize(codeSource)).map(it -> it.toString().replace('\\', '/')).collect(Collectors.toSet());
                    }
                } else if (fileName.endsWith("jar") || fileName.endsWith("zip")) {
                    paths = new HashSet<String>();
                    try (ZipInputStream is = new ZipInputStream(Files.newInputStream(codeSource, new OpenOption[0]));){
                        ZipEntry entry;
                        while ((entry = is.getNextEntry()) != null) {
                            if (!entry.getName().endsWith(EXPECTED_EXTENSION)) continue;
                            paths.add(entry.getName());
                        }
                    }
                } else {
                    throw new IOException("Unknown file type " + codeSource);
                }
                lastCodeSource = codeSource;
                lastKnownResourceBundles = Collections.unmodifiableSet(paths);
            } else {
                paths = Objects.requireNonNull(lastKnownResourceBundles, "has been set");
            }
            return paths.stream().filter(it -> it.startsWith(bundlePathName)).map(it -> it.substring(bundlePathName.length(), it.length() - EXPECTED_EXTENSION.length())).filter(it -> it.isEmpty() || it.startsWith("_")).map(it -> {
                if (it.isEmpty()) {
                    return DEFAULT_LOCALE;
                }
                return Translator.parseLocale((String)it.substring(1));
            });
        }
        catch (Exception ex) {
            LOGGER.error("Failed to read known locales for bundle {}", (Object)bundleName, (Object)ex);
            return Stream.of(DEFAULT_LOCALE);
        }
    }

    public static void registerAllTranslations(String bundleName, Stream<Locale> languages, ClassLoader loader) {
        TranslationRegistry registry = TranslationRegistry.create((Key)Key.key((String)"permissionsex", (String)bundleName.toLowerCase(Locale.ROOT)));
        registry.defaultLocale(DEFAULT_LOCALE);
        languages.forEach(language -> {
            ResourceBundle bundle = ResourceBundle.getBundle(bundleName, language, loader, UTF8ResourceBundleControl.get());
            for (String key : bundle.keySet()) {
                try {
                    registry.register(TranslatableProvider.formatKey(bundleName, key), language, new MessageFormat(SINGLE_QUOTE_PATTERN.matcher(bundle.getString(key)).replaceAll("''")));
                }
                catch (Exception ex) {
                    LOGGER.warn("Failed to register translation key {} in bundle {}", new Object[]{key, bundleName, ex});
                }
            }
        });
        GlobalTranslator.get().addSource((Translator)registry);
    }

    private static String formatKey(String bundleName, String key) {
        return bundleName + '/' + key;
    }
}

