/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex;

import ca.stellardrift.permissionsex.datastore.DataStore;
import ca.stellardrift.permissionsex.logging.FormattedLogger;
import ca.stellardrift.permissionsex.subject.CalculatedSubject;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.subject.SubjectType;
import ca.stellardrift.permissionsex.subject.SubjectTypeCollection;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface PermissionsEngine {
    public static final String SUBJECTS_USER = "user";
    public static final String SUBJECTS_GROUP = "group";
    public static final SubjectType<String> SUBJECTS_DEFAULTS = SubjectType.stringIdentBuilder("default").transientHasPriority(false).build();
    public static final SubjectType<String> SUBJECTS_FALLBACK = SubjectType.stringIdentBuilder("fallback").build();

    public <I> SubjectTypeCollection<I> subjects(SubjectType<I> var1);

    default public <I> CompletableFuture<CalculatedSubject> subject(SubjectRef<I> reference) {
        return this.subjects(reference.type()).get(reference.identifier());
    }

    public Collection<? extends SubjectTypeCollection<?>> loadedSubjectTypes();

    public Set<SubjectType<?>> knownSubjectTypes();

    public <V> CompletableFuture<V> doBulkOperation(Function<DataStore, CompletableFuture<V>> var1);

    public boolean debugMode();

    default public void debugMode(boolean enabled) {
        this.debugMode(enabled, null);
    }

    public void debugMode(boolean var1, @Nullable Pattern var2);

    public Executor asyncExecutor();

    public FormattedLogger logger();

    public Path baseDirectory();

    @Deprecated
    public DataSource dataSourceForUrl(String var1) throws SQLException;
}

