/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.bukkit;

import ca.stellardrift.permissionsex.bukkit.CommanderKt;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Locale;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.Nullable;

class Compatibility {
    private static final @Nullable MethodHandle locale;
    private static final boolean localeOnSpigot;

    private Compatibility() {
    }

    public static Locale getLocale(Player player) {
        String result = null;
        try {
            if (localeOnSpigot) {
                result = locale.invoke(player.spigot());
            } else if (locale != null) {
                result = locale.invoke(player);
            }
        }
        catch (Throwable t) {
            player.getServer().getLogger().severe("PermissionsEx: Unable to determine locale for player " + player.getName());
        }
        return result == null ? Locale.getDefault() : CommanderKt.toLocale(result);
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodType localeType = MethodType.methodType(String.class);
        MethodHandle _locale = null;
        boolean _localeOnSpigot = false;
        try {
            try {
                _locale = lookup.findVirtual(Player.class, "getLocale", localeType);
            }
            catch (NoSuchMethodException ex) {
                try {
                    _locale = lookup.findVirtual(Player.Spigot.class, "getLocale", localeType);
                    _localeOnSpigot = true;
                }
                catch (NoSuchMethodException ex2) {
                    System.err.println("PermissionsEx: Unable to find method to get player locale!");
                    ex.printStackTrace();
                }
            }
        }
        catch (IllegalAccessException ex) {
            System.err.println("PermissionsEx: Unable to access method to get player locale!");
            ex.printStackTrace();
        }
        locale = _locale;
        localeOnSpigot = _localeOnSpigot;
    }
}

