/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.bukkit;

import java.lang.reflect.Field;

class FieldReplacer<I, V> {
    private final Class<V> requiredType;
    private final Field field;

    public FieldReplacer(Class<? extends I> clazz, String fieldName, Class<V> requiredType) {
        this.requiredType = requiredType;
        this.field = FieldReplacer.field(clazz, fieldName);
        if (this.field == null) {
            throw new ExceptionInInitializerError("No such field " + fieldName + " in class " + clazz);
        }
        this.field.setAccessible(true);
        if (!requiredType.isAssignableFrom(this.field.getType())) {
            throw new ExceptionInInitializerError("Field of wrong type");
        }
    }

    public V get(I instance) {
        try {
            return this.requiredType.cast(this.field.get(instance));
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    public void set(I instance, V newValue) {
        try {
            this.field.set(instance, newValue);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    private static Field field(Class<?> clazz, String fieldName) {
        while (clazz != null && clazz != Object.class) {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }
}

