/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.context;

import ca.stellardrift.permissionsex.context.ContextDefinition;
import ca.stellardrift.permissionsex.subject.CalculatedSubject;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class SimpleContextDefinition
extends ContextDefinition<String> {
    public static SimpleContextDefinition context(String name, BiConsumer<CalculatedSubject, Consumer<String>> valueAccumulator) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(valueAccumulator, "valueAccumulator");
        return new FromFunction(name, valueAccumulator);
    }

    protected SimpleContextDefinition(String name) {
        super(name);
    }

    @Override
    public void accumulateCurrentValues(CalculatedSubject subject2, Consumer<String> consumer) {
    }

    @Override
    public boolean matches(String ownVal, String testVal) {
        return Objects.equals(ownVal, testVal);
    }

    @Override
    public String serialize(String canonicalValue) {
        return canonicalValue;
    }

    @Override
    public String deserialize(String userValue) {
        return userValue;
    }

    static final class FromFunction
    extends SimpleContextDefinition {
        private final BiConsumer<CalculatedSubject, Consumer<String>> valueAccumulator;

        FromFunction(String name, BiConsumer<CalculatedSubject, Consumer<String>> valueAccumulator) {
            super(name);
            this.valueAccumulator = valueAccumulator;
        }

        @Override
        public void accumulateCurrentValues(CalculatedSubject subject2, Consumer<String> consumer) {
            this.valueAccumulator.accept(subject2, consumer);
        }
    }

    public static final class Fallback
    extends SimpleContextDefinition {
        public Fallback(String name) {
            super(name);
        }
    }
}

