/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.datastore;

import ca.stellardrift.permissionsex.PermissionsEngine;
import ca.stellardrift.permissionsex.context.ContextInheritance;
import ca.stellardrift.permissionsex.exception.PermissionsLoadingException;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.ConfigurationNode;
import ca.stellardrift.permissionsex.rank.RankLadder;
import ca.stellardrift.permissionsex.subject.ImmutableSubjectData;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface DataStore {
    public String getName();

    public boolean initialize(PermissionsEngine var1) throws PermissionsLoadingException;

    public void close();

    public CompletableFuture<ImmutableSubjectData> getData(String var1, String var2, @Nullable Consumer<ImmutableSubjectData> var3);

    public CompletableFuture<ImmutableSubjectData> setData(String var1, String var2, @Nullable ImmutableSubjectData var3);

    public CompletableFuture<Void> moveData(String var1, String var2, String var3, String var4);

    public CompletableFuture<Boolean> isRegistered(String var1, String var2);

    public Iterable<Map.Entry<String, ImmutableSubjectData>> getAll(String var1);

    public Set<String> getAllIdentifiers(String var1);

    public Set<String> getRegisteredTypes();

    public CompletableFuture<Set<String>> getDefinedContextKeys();

    public String serialize(ConfigurationNode var1) throws PermissionsLoadingException;

    public Iterable<Map.Entry<Map.Entry<String, String>, ImmutableSubjectData>> getAll();

    public <T> CompletableFuture<T> performBulkOperation(Function<DataStore, T> var1);

    public Iterable<String> getAllRankLadders();

    public CompletableFuture<RankLadder> getRankLadder(String var1, @Nullable Consumer<RankLadder> var2);

    public CompletableFuture<Boolean> hasRankLadder(String var1);

    public CompletableFuture<RankLadder> setRankLadder(String var1, @Nullable RankLadder var2);

    public CompletableFuture<ContextInheritance> getContextInheritance(@Nullable Consumer<ContextInheritance> var1);

    public CompletableFuture<ContextInheritance> setContextInheritance(ContextInheritance var1);
}

