/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.com.github.benmanes.caffeine.cache;

import ca.stellardrift.permissionsex.ext.com.github.benmanes.caffeine.cache.AccessOrderDeque;
import ca.stellardrift.permissionsex.ext.com.github.benmanes.caffeine.cache.CacheLoader;
import ca.stellardrift.permissionsex.ext.com.github.benmanes.caffeine.cache.Caffeine;
import ca.stellardrift.permissionsex.ext.com.github.benmanes.caffeine.cache.Expiry;
import ca.stellardrift.permissionsex.ext.com.github.benmanes.caffeine.cache.MpscGrowableArrayQueue;
import ca.stellardrift.permissionsex.ext.com.github.benmanes.caffeine.cache.Node;
import ca.stellardrift.permissionsex.ext.com.github.benmanes.caffeine.cache.Pacer;
import ca.stellardrift.permissionsex.ext.com.github.benmanes.caffeine.cache.Scheduler;
import ca.stellardrift.permissionsex.ext.com.github.benmanes.caffeine.cache.Ticker;
import ca.stellardrift.permissionsex.ext.com.github.benmanes.caffeine.cache.TimerWheel;
import ca.stellardrift.permissionsex.ext.com.github.benmanes.caffeine.cache.WIS;

class WISA<K, V>
extends WIS<K, V> {
    final Ticker ticker;
    final AccessOrderDeque<Node<K, V>> accessOrderWindowDeque;
    final Expiry<K, V> expiry;
    final TimerWheel<K, V> timerWheel;
    volatile long expiresAfterAccessNanos;
    final MpscGrowableArrayQueue<Runnable> writeBuffer;
    final Pacer pacer;

    WISA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
        super(builder, cacheLoader, async);
        this.ticker = builder.getTicker();
        this.accessOrderWindowDeque = builder.evicts() || builder.expiresAfterAccess() ? new AccessOrderDeque() : null;
        this.expiry = builder.getExpiry(this.isAsync);
        this.timerWheel = builder.expiresVariable() ? new TimerWheel(this) : null;
        this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        this.writeBuffer = new MpscGrowableArrayQueue(4, WRITE_BUFFER_MAX);
        this.pacer = builder.getScheduler() == Scheduler.disabledScheduler() ? null : new Pacer(builder.getScheduler());
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected final AccessOrderDeque<Node<K, V>> accessOrderWindowDeque() {
        return this.accessOrderWindowDeque;
    }

    @Override
    protected final boolean expiresVariable() {
        return this.timerWheel != null;
    }

    @Override
    protected final Expiry<K, V> expiry() {
        return this.expiry;
    }

    @Override
    protected final TimerWheel<K, V> timerWheel() {
        return this.timerWheel;
    }

    @Override
    protected final boolean expiresAfterAccess() {
        return this.timerWheel == null;
    }

    @Override
    protected final long expiresAfterAccessNanos() {
        return this.expiresAfterAccessNanos;
    }

    @Override
    protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
        this.expiresAfterAccessNanos = expiresAfterAccessNanos;
    }

    @Override
    protected final MpscGrowableArrayQueue<Runnable> writeBuffer() {
        return this.writeBuffer;
    }

    @Override
    protected final boolean buffersWrites() {
        return true;
    }

    @Override
    public final Pacer pacer() {
        return this.pacer;
    }
}

