/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.net.kyori.adventure.nbt;

import ca.stellardrift.permissionsex.ext.net.kyori.adventure.nbt.BinaryTag;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.nbt.BinaryTagType;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.nbt.BinaryTagTypes;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.nbt.CompoundBinaryTag;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.nbt.IOStreamUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class BinaryTagIO {
    private BinaryTagIO() {
    }

    public static @NonNull CompoundBinaryTag readPath(@NonNull Path path) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            CompoundBinaryTag compoundBinaryTag = BinaryTagIO.readInputStream(is);
            return compoundBinaryTag;
        }
    }

    public static @NonNull CompoundBinaryTag readInputStream(@NonNull InputStream input) throws IOException {
        return BinaryTagIO.readDataInput(new DataInputStream(IOStreamUtil.closeShield(input)));
    }

    public static @NonNull CompoundBinaryTag readCompressedPath(@NonNull Path path) throws IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            CompoundBinaryTag compoundBinaryTag = BinaryTagIO.readCompressedInputStream(is);
            return compoundBinaryTag;
        }
    }

    public static @NonNull CompoundBinaryTag readCompressedInputStream(@NonNull InputStream input) throws IOException {
        try (DataInputStream dis = new DataInputStream(new BufferedInputStream(new GZIPInputStream(IOStreamUtil.closeShield(input))));){
            CompoundBinaryTag compoundBinaryTag = BinaryTagIO.readDataInput(dis);
            return compoundBinaryTag;
        }
    }

    public static @NonNull CompoundBinaryTag readDataInput(@NonNull DataInput input) throws IOException {
        BinaryTagType<BinaryTag> type = BinaryTagType.of(input.readByte());
        if (type != BinaryTagTypes.COMPOUND) {
            throw new IOException(String.format("Expected root tag to be a %s, was %s", BinaryTagTypes.COMPOUND, type));
        }
        input.skipBytes(input.readUnsignedShort());
        return BinaryTagTypes.COMPOUND.read(input);
    }

    public static void writePath(@NonNull CompoundBinaryTag tag, @NonNull Path path) throws IOException {
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            BinaryTagIO.writeOutputStream(tag, os);
        }
    }

    public static void writeOutputStream(@NonNull CompoundBinaryTag tag, @NonNull OutputStream output) throws IOException {
        BinaryTagIO.writeDataOutput(tag, new DataOutputStream(output));
    }

    public static void writeCompressedPath(@NonNull CompoundBinaryTag tag, @NonNull Path path) throws IOException {
        BinaryTagIO.writeCompressedOutputStream(tag, Files.newOutputStream(path, new OpenOption[0]));
    }

    public static void writeCompressedOutputStream(@NonNull CompoundBinaryTag tag, @NonNull OutputStream output) throws IOException {
        try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(IOStreamUtil.closeShield(output))));){
            BinaryTagIO.writeDataOutput(tag, dos);
        }
    }

    public static void writeDataOutput(@NonNull CompoundBinaryTag tag, @NonNull DataOutput output) throws IOException {
        output.writeByte(BinaryTagTypes.COMPOUND.id());
        output.writeUTF("");
        BinaryTagTypes.COMPOUND.write(tag, output);
    }

    static {
        BinaryTagTypes.COMPOUND.id();
    }
}

