/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.net.kyori.adventure.platform.viaversion;

import ca.stellardrift.permissionsex.ext.net.kyori.adventure.audience.MessageType;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.bossbar.BossBar;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.identity.Identity;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.platform.facet.Facet;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.platform.facet.FacetBase;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.platform.facet.Knob;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.myles.ViaVersion.api.PacketWrapper;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.protocol.ClientboundPacketType;
import us.myles.ViaVersion.api.protocol.Protocol;
import us.myles.ViaVersion.api.protocol.ProtocolRegistry;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.protocols.base.ProtocolInfo;

public class ViaFacet<V>
extends FacetBase<V>
implements Facet.Message<V, String> {
    private static final String PACKAGE = "us.myles.ViaVersion";
    private static final boolean SUPPORTED;
    private final Function<V, UserConnection> connectionFunction;
    private final int minProtocol;

    public ViaFacet(@NonNull Class<? extends V> viewerClass, @NonNull Function<V, UserConnection> connectionFunction, int minProtocol) {
        super(viewerClass);
        this.connectionFunction = connectionFunction;
        this.minProtocol = minProtocol;
    }

    @Override
    public boolean isSupported() {
        return super.isSupported() && SUPPORTED && this.connectionFunction != null && this.minProtocol >= 0;
    }

    @Override
    public boolean isApplicable(@NonNull V viewer) {
        return super.isApplicable(viewer) && this.minProtocol > ProtocolRegistry.SERVER_PROTOCOL && this.findProtocol(viewer) >= this.minProtocol;
    }

    public @Nullable UserConnection findConnection(@NonNull V viewer) {
        return this.connectionFunction.apply(viewer);
    }

    public int findProtocol(@NonNull V viewer) {
        ProtocolInfo info;
        UserConnection connection = this.findConnection(viewer);
        if (connection != null && (info = connection.getProtocolInfo()) != null) {
            return info.getProtocolVersion();
        }
        return -1;
    }

    @Override
    public @NonNull String createMessage(@NonNull V viewer, @NonNull Component message) {
        int protocol = this.findProtocol(viewer);
        if (protocol >= 713) {
            return (String)GsonComponentSerializer.gson().serialize(message);
        }
        return (String)GsonComponentSerializer.colorDownsamplingGson().serialize(message);
    }

    static {
        boolean supported = false;
        try {
            Class.forName("us.myles.ViaVersion.api.protocol.ProtocolRegistry");
            supported = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SUPPORTED = supported && Knob.isEnabled("viaversion", true);
    }

    public static final class TabList<V>
    extends ProtocolBased<V>
    implements Facet.TabList<V, String> {
        public TabList(@NonNull Class<? extends V> viewerClass, @NonNull Function<V, UserConnection> userConnection) {
            super("1_16", "1_15_2", 713, "TAB_LIST", viewerClass, userConnection);
        }

        @Override
        public void send(V viewer, @Nullable String header, @Nullable String footer) {
            PacketWrapper packet = this.createPacket(viewer);
            packet.write(Type.STRING, (Object)header);
            packet.write(Type.STRING, (Object)footer);
            this.sendPacket(packet);
        }
    }

    public static final class BossBar<V>
    extends ProtocolBased<V>
    implements Facet.BossBarPacket<V> {
        private final Set<V> viewers;
        private UUID id;
        private String title;
        private float health;
        private int color;
        private int overlay;
        private byte flags;

        private BossBar(@NonNull String fromProtocol, @NonNull String toProtocol, @NonNull Class<? extends V> viewerClass, @NonNull Function<V, UserConnection> connectionFunction, Collection<V> viewers) {
            super(fromProtocol, toProtocol, 356, "BOSSBAR", viewerClass, connectionFunction);
            this.viewers = new CopyOnWriteArraySet<V>(viewers);
        }

        @Override
        public void bossBarInitialized(@NonNull ca.stellardrift.permissionsex.ext.net.kyori.adventure.bossbar.BossBar bar) {
            Facet.BossBarPacket.super.bossBarInitialized(bar);
            this.id = UUID.randomUUID();
            this.broadcastPacket(0);
        }

        @Override
        public void bossBarNameChanged(@NonNull ca.stellardrift.permissionsex.ext.net.kyori.adventure.bossbar.BossBar bar, @NonNull Component oldName, @NonNull Component newName) {
            if (!this.viewers.isEmpty()) {
                this.title = this.createMessage((Object)this.viewers.iterator().next(), newName);
                this.broadcastPacket(3);
            }
        }

        @Override
        public void bossBarProgressChanged(@NonNull ca.stellardrift.permissionsex.ext.net.kyori.adventure.bossbar.BossBar bar, float oldPercent, float newPercent) {
            this.health = newPercent;
            this.broadcastPacket(2);
        }

        @Override
        public void bossBarColorChanged(@NonNull ca.stellardrift.permissionsex.ext.net.kyori.adventure.bossbar.BossBar bar,  @NonNull BossBar.Color oldColor,  @NonNull BossBar.Color newColor) {
            this.color = this.createColor(newColor);
            this.broadcastPacket(4);
        }

        @Override
        public void bossBarOverlayChanged(@NonNull ca.stellardrift.permissionsex.ext.net.kyori.adventure.bossbar.BossBar bar,  @NonNull BossBar.Overlay oldOverlay,  @NonNull BossBar.Overlay newOverlay) {
            this.overlay = this.createOverlay(newOverlay);
            this.broadcastPacket(4);
        }

        @Override
        public void bossBarFlagsChanged(@NonNull ca.stellardrift.permissionsex.ext.net.kyori.adventure.bossbar.BossBar bar, @NonNull Set<BossBar.Flag> flagsAdded, @NonNull Set<BossBar.Flag> flagsRemoved) {
            this.flags = this.createFlag(this.flags, flagsAdded, flagsRemoved);
            this.broadcastPacket(5);
        }

        public void sendPacket(@NonNull V viewer, int action) {
            PacketWrapper packet = this.createPacket(viewer);
            packet.write(Type.UUID, (Object)this.id);
            packet.write((Type)Type.VAR_INT, (Object)action);
            if (action == 0 || action == 3) {
                packet.write(Type.STRING, (Object)this.title);
            }
            if (action == 0 || action == 2) {
                packet.write((Type)Type.FLOAT, (Object)Float.valueOf(this.health));
            }
            if (action == 0 || action == 4) {
                packet.write((Type)Type.VAR_INT, (Object)this.color);
                packet.write((Type)Type.VAR_INT, (Object)this.overlay);
            }
            if (action == 0 || action == 5) {
                packet.write(Type.BYTE, (Object)this.flags);
            }
            this.sendPacket(packet);
        }

        public void broadcastPacket(int action) {
            if (this.isEmpty()) {
                return;
            }
            for (V viewer : this.viewers) {
                this.sendPacket(viewer, action);
            }
        }

        @Override
        public void addViewer(@NonNull V viewer) {
            if (this.viewers.add(viewer)) {
                this.sendPacket(viewer, 0);
            }
        }

        @Override
        public void removeViewer(@NonNull V viewer) {
            if (this.viewers.remove(viewer)) {
                this.sendPacket(viewer, 1);
            }
        }

        @Override
        public boolean isEmpty() {
            return this.id == null || this.viewers.isEmpty();
        }

        @Override
        public void close() {
            this.broadcastPacket(1);
            this.viewers.clear();
        }

        public static class Builder1_9_To_1_15<V>
        extends ViaFacet<V>
        implements Facet.BossBar.Builder<V, Facet.BossBar<V>> {
            public Builder1_9_To_1_15(@NonNull Class<? extends V> viewerClass, @NonNull Function<V, UserConnection> connectionFunction) {
                super(viewerClass, connectionFunction, 356);
            }

            @Override
            public  @NonNull Facet.BossBar<V> createBossBar(@NonNull Collection<V> viewer) {
                return new BossBar("1_9", "1_8", this.viewerClass, this::findConnection, viewer);
            }
        }

        public static class Builder<V>
        extends ViaFacet<V>
        implements Facet.BossBar.Builder<V, Facet.BossBar<V>> {
            public Builder(@NonNull Class<? extends V> viewerClass, @NonNull Function<V, UserConnection> connectionFunction) {
                super(viewerClass, connectionFunction, 713);
            }

            @Override
            public  @NonNull Facet.BossBar<V> createBossBar(@NonNull Collection<V> viewer) {
                return new BossBar("1_16", "1_15_2", this.viewerClass, this::findConnection, viewer);
            }
        }
    }

    public static class Title<V>
    extends ProtocolBased<V>
    implements Facet.TitlePacket<V, String, Consumer<V>> {
        protected Title(@NonNull String fromProtocol, @NonNull String toProtocol, int minProtocol, @NonNull Class<? extends V> viewerClass, @NonNull Function<V, UserConnection> connectionFunction) {
            super(fromProtocol, toProtocol, minProtocol, "TITLE", viewerClass, connectionFunction);
        }

        public Title(@NonNull Class<? extends V> viewerClass, @NonNull Function<V, UserConnection> connectionFunction) {
            this("1_16", "1_15_2", 713, viewerClass, connectionFunction);
        }

        @Override
        public @NonNull Consumer<V> createTitle(@Nullable String title, @Nullable String subTitle, int inTicks, int stayTicks, int outTicks) {
            return viewer -> {
                PacketWrapper packet;
                if (inTicks > -1 || stayTicks > -1 || outTicks > -1) {
                    packet = this.createPacket(viewer);
                    packet.write((Type)Type.VAR_INT, (Object)3);
                    packet.write(Type.INT, (Object)inTicks);
                    packet.write(Type.INT, (Object)stayTicks);
                    packet.write(Type.INT, (Object)outTicks);
                    this.sendPacket(packet);
                }
                if (subTitle != null) {
                    packet = this.createPacket(viewer);
                    packet.write((Type)Type.VAR_INT, (Object)1);
                    packet.write(Type.STRING, (Object)subTitle);
                    this.sendPacket(packet);
                }
                if (title != null) {
                    packet = this.createPacket(viewer);
                    packet.write((Type)Type.VAR_INT, (Object)0);
                    packet.write(Type.STRING, (Object)title);
                    this.sendPacket(packet);
                }
            };
        }

        @Override
        public void showTitle(@NonNull V viewer, @NonNull Consumer<V> title) {
            title.accept(viewer);
        }

        @Override
        public void clearTitle(@NonNull V viewer) {
            PacketWrapper packet = this.createPacket(viewer);
            packet.write((Type)Type.VAR_INT, (Object)4);
            this.sendPacket(packet);
        }

        @Override
        public void resetTitle(@NonNull V viewer) {
            PacketWrapper packet = this.createPacket(viewer);
            packet.write((Type)Type.VAR_INT, (Object)5);
            this.sendPacket(packet);
        }
    }

    public static class ActionBarTitle<V>
    extends ProtocolBased<V>
    implements Facet.ActionBar<V, String> {
        public ActionBarTitle(@NonNull Class<? extends V> viewerClass, @NonNull Function<V, UserConnection> connectionFunction) {
            super("1_11", "1_10", 310, "TITLE", viewerClass, connectionFunction);
        }

        @Override
        public void sendMessage(@NonNull V viewer, @NonNull String message) {
            PacketWrapper packet = this.createPacket(viewer);
            packet.write((Type)Type.VAR_INT, (Object)2);
            packet.write(Type.STRING, (Object)message);
            this.sendPacket(packet);
        }
    }

    public static class ActionBar<V>
    extends Chat<V>
    implements Facet.ActionBar<V, String> {
        public ActionBar(@NonNull Class<? extends V> viewerClass, @NonNull Function<V, UserConnection> connectionFunction) {
            super(viewerClass, connectionFunction);
        }

        @Override
        public byte createMessageType(@NonNull MessageType type) {
            return 2;
        }

        @Override
        public void sendMessage(@NonNull V viewer, @NonNull String message) {
            this.sendMessage(viewer, Identity.nil(), message, MessageType.CHAT);
        }
    }

    public static class Chat<V>
    extends ProtocolBased<V>
    implements Facet.ChatPacket<V, String> {
        public Chat(@NonNull Class<? extends V> viewerClass, @NonNull Function<V, UserConnection> connectionFunction) {
            super("1_16", "1_15_2", 713, "CHAT_MESSAGE", viewerClass, connectionFunction);
        }

        @Override
        public void sendMessage(@NonNull V viewer, @NonNull Identity source, @NonNull String message, @NonNull MessageType type) {
            PacketWrapper packet = this.createPacket(viewer);
            packet.write(Type.STRING, (Object)message);
            packet.write(Type.BYTE, (Object)this.createMessageType(type));
            packet.write(Type.UUID, (Object)source.uuid());
            this.sendPacket(packet);
        }
    }

    public static class ProtocolBased<V>
    extends ViaFacet<V> {
        private final Class<? extends Protocol<?, ?, ?, ?>> protocolClass;
        private final Class<? extends ClientboundPacketType> packetClass;
        private final int packetId;

        protected ProtocolBased(@NonNull String fromProtocol, @NonNull String toProtocol, int minProtocol, @NonNull String packetName, @NonNull Class<? extends V> viewerClass, @NonNull Function<V, UserConnection> connectionFunction) {
            super(viewerClass, connectionFunction, minProtocol);
            String protocolClassName = MessageFormat.format("{0}.protocols.protocol{1}to{2}.Protocol{1}To{2}", ViaFacet.PACKAGE, fromProtocol, toProtocol);
            String packetClassName = MessageFormat.format("{0}.protocols.protocol{1}to{2}.ClientboundPackets{1}", ViaFacet.PACKAGE, fromProtocol, toProtocol);
            Class<?> protocolClass = null;
            Class<?> packetClass = null;
            int packetId = -1;
            try {
                protocolClass = Class.forName(protocolClassName);
                packetClass = Class.forName(packetClassName);
                for (ClientboundPacketType type : (ClientboundPacketType[])packetClass.getEnumConstants()) {
                    if (!type.name().equals(packetName)) continue;
                    packetId = type.ordinal();
                    break;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.protocolClass = protocolClass;
            this.packetClass = packetClass;
            this.packetId = packetId;
        }

        @Override
        public boolean isSupported() {
            return super.isSupported() && this.protocolClass != null && this.packetClass != null && this.packetId >= 0;
        }

        public PacketWrapper createPacket(@NonNull V viewer) {
            return new PacketWrapper(this.packetId, null, this.findConnection(viewer));
        }

        public void sendPacket(@NonNull PacketWrapper packet) {
            if (packet.user() == null) {
                return;
            }
            try {
                packet.send(this.protocolClass);
            }
            catch (Throwable error2) {
                Knob.logError(error2, "Failed to send ViaVersion packet: %s %s", packet.user(), packet);
            }
        }
    }
}

