/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.net.kyori.adventure.sound;

import ca.stellardrift.permissionsex.ext.net.kyori.adventure.key.Key;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.sound.SoundImpl;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.util.Index;
import ca.stellardrift.permissionsex.ext.net.kyori.examination.Examinable;
import java.util.Objects;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface Sound
extends Examinable {
    public static @NonNull Sound sound(final @NonNull Key name, @NonNull Source source, float volume, float pitch) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(source, "source");
        return new SoundImpl(source, volume, pitch){

            @Override
            public @NonNull Key name() {
                return name;
            }
        };
    }

    public static @NonNull Sound sound(@NonNull Type type, @NonNull Source source, float volume, float pitch) {
        Objects.requireNonNull(type, "type");
        return Sound.sound(type.key(), source, volume, pitch);
    }

    public static @NonNull Sound sound(final @NonNull Supplier<? extends Type> type, @NonNull Source source, float volume, float pitch) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(source, "source");
        return new SoundImpl(source, volume, pitch){

            @Override
            public @NonNull Key name() {
                return ((Type)type.get()).key();
            }
        };
    }

    public @NonNull Key name();

    public @NonNull Source source();

    public float volume();

    public float pitch();

    public static enum Source {
        MASTER("master"),
        MUSIC("music"),
        RECORD("record"),
        WEATHER("weather"),
        BLOCK("block"),
        HOSTILE("hostile"),
        NEUTRAL("neutral"),
        PLAYER("player"),
        AMBIENT("ambient"),
        VOICE("voice");

        public static final Index<String, Source> NAMES;
        private final String name;

        private Source(String name) {
            this.name = name;
        }

        static {
            NAMES = Index.create(Source.class, source -> source.name);
        }
    }

    public static interface Type {
        public @NonNull Key key();
    }
}

