/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.format;

import ca.stellardrift.permissionsex.ext.net.kyori.adventure.key.Key;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.event.ClickEvent;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.event.HoverEvent;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.event.HoverEventSource;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.format.StyleBuilderApplicable;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.format.StyleImpl;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.format.TextColor;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.format.TextDecoration;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.util.Buildable;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.util.ShadyPines;
import ca.stellardrift.permissionsex.ext.net.kyori.examination.Examinable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Style
extends Buildable<Style, Builder>,
Examinable {
    public static final Key DEFAULT_FONT = Key.key("default");

    public static @NonNull Style empty() {
        return StyleImpl.EMPTY;
    }

    public static @NonNull Builder style() {
        return new StyleImpl.BuilderImpl();
    }

    public static @NonNull Style style(@NonNull Consumer<Builder> consumer) {
        return (Style)Buildable.configureAndBuild(Style.style(), consumer);
    }

    public static @NonNull Style style(@Nullable TextColor color) {
        if (color == null) {
            return Style.empty();
        }
        return new StyleImpl(null, color, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, null, null, null);
    }

    public static @NonNull Style style(@NonNull TextDecoration decoration) {
        return Style.style().decoration(decoration, true).build();
    }

    public static @NonNull Style style(@Nullable TextColor color, TextDecoration ... decorations) {
        Builder builder = Style.style();
        builder.color(color);
        StyleImpl.decorate(builder, decorations);
        return builder.build();
    }

    public static @NonNull Style style(@Nullable TextColor color, Set<TextDecoration> decorations) {
        Builder builder = Style.style();
        builder.color(color);
        if (!decorations.isEmpty()) {
            for (TextDecoration decoration : decorations) {
                builder.decoration(decoration, true);
            }
        }
        return builder.build();
    }

    public static @NonNull Style style(StyleBuilderApplicable ... applicables) {
        if (applicables.length == 0) {
            return Style.empty();
        }
        Builder builder = Style.style();
        int length = applicables.length;
        for (int i = 0; i < length; ++i) {
            applicables[i].styleApply(builder);
        }
        return builder.build();
    }

    public static @NonNull Style style(@NonNull Iterable<? extends StyleBuilderApplicable> applicables) {
        Builder builder = Style.style();
        for (StyleBuilderApplicable styleBuilderApplicable : applicables) {
            styleBuilderApplicable.styleApply(builder);
        }
        return builder.build();
    }

    default public @NonNull Style edit(@NonNull Consumer<Builder> consumer) {
        return this.edit(consumer, Merge.Strategy.ALWAYS);
    }

    default public @NonNull Style edit(@NonNull Consumer<Builder> consumer, @NonNull Merge.Strategy strategy) {
        return Style.style((Builder style) -> {
            if (strategy == Merge.Strategy.ALWAYS) {
                style.merge(this, strategy);
            }
            consumer.accept((Builder)style);
            if (strategy == Merge.Strategy.IF_ABSENT_ON_TARGET) {
                style.merge(this, strategy);
            }
        });
    }

    public @Nullable Key font();

    public @NonNull Style font(@Nullable Key var1);

    public @Nullable TextColor color();

    public @NonNull Style color(@Nullable TextColor var1);

    public @NonNull Style colorIfAbsent(@Nullable TextColor var1);

    default public boolean hasDecoration(@NonNull TextDecoration decoration) {
        return this.decoration(decoration) == TextDecoration.State.TRUE;
    }

    public @NonNull TextDecoration.State decoration(@NonNull TextDecoration var1);

    default public @NonNull Style decorate(@NonNull TextDecoration decoration) {
        return this.decoration(decoration, TextDecoration.State.TRUE);
    }

    default public @NonNull Style decoration(@NonNull TextDecoration decoration, boolean flag) {
        return this.decoration(decoration, TextDecoration.State.byBoolean(flag));
    }

    public @NonNull Style decoration(@NonNull TextDecoration var1, @NonNull TextDecoration.State var2);

    public @NonNull Map<TextDecoration, TextDecoration.State> decorations();

    public @NonNull Style decorations(@NonNull Map<TextDecoration, TextDecoration.State> var1);

    public @Nullable ClickEvent clickEvent();

    public @NonNull Style clickEvent(@Nullable ClickEvent var1);

    public @Nullable HoverEvent<?> hoverEvent();

    public @NonNull Style hoverEvent(@Nullable HoverEventSource<?> var1);

    public @Nullable String insertion();

    public @NonNull Style insertion(@Nullable String var1);

    default public @NonNull Style merge(@NonNull Style that) {
        return this.merge(that, Merge.all());
    }

    default public @NonNull Style merge(@NonNull Style that, @NonNull Merge.Strategy strategy) {
        return this.merge(that, strategy, Merge.all());
    }

    default public @NonNull Style merge(@NonNull Style that, @NonNull Merge merge) {
        return this.merge(that, Collections.singleton(merge));
    }

    default public @NonNull Style merge(@NonNull Style that, @NonNull Merge.Strategy strategy, @NonNull Merge merge) {
        return this.merge(that, strategy, Collections.singleton(merge));
    }

    default public @NonNull Style merge(@NonNull Style that, Merge ... merges) {
        return this.merge(that, Merge.of(merges));
    }

    default public @NonNull Style merge(@NonNull Style that, @NonNull Merge.Strategy strategy, Merge ... merges) {
        return this.merge(that, strategy, Merge.of(merges));
    }

    default public @NonNull Style merge(@NonNull Style that, @NonNull Set<Merge> merges) {
        return this.merge(that, Merge.Strategy.ALWAYS, merges);
    }

    public @NonNull Style merge(@NonNull Style var1, @NonNull Merge.Strategy var2, @NonNull Set<Merge> var3);

    public boolean isEmpty();

    @Override
    public @NonNull Builder toBuilder();

    public static interface Builder
    extends Buildable.Builder<Style> {
        public @NonNull Builder font(@Nullable Key var1);

        public @NonNull Builder color(@Nullable TextColor var1);

        public @NonNull Builder colorIfAbsent(@Nullable TextColor var1);

        default public @NonNull Builder decorate(@NonNull TextDecoration decoration) {
            return this.decoration(decoration, TextDecoration.State.TRUE);
        }

        default public @NonNull Builder decorate(TextDecoration ... decorations) {
            int length = decorations.length;
            for (int i = 0; i < length; ++i) {
                this.decorate(decorations[i]);
            }
            return this;
        }

        default public @NonNull Builder decoration(@NonNull TextDecoration decoration, boolean flag) {
            return this.decoration(decoration, TextDecoration.State.byBoolean(flag));
        }

        public @NonNull Builder decoration(@NonNull TextDecoration var1, @NonNull TextDecoration.State var2);

        public @NonNull Builder clickEvent(@Nullable ClickEvent var1);

        public @NonNull Builder hoverEvent(@Nullable HoverEventSource<?> var1);

        public @NonNull Builder insertion(@Nullable String var1);

        default public @NonNull Builder merge(@NonNull Style that) {
            return this.merge(that, Merge.all());
        }

        default public @NonNull Builder merge(@NonNull Style that, @NonNull Merge.Strategy strategy) {
            return this.merge(that, strategy, Merge.all());
        }

        default public @NonNull Builder merge(@NonNull Style that, Merge ... merges) {
            if (merges.length == 0) {
                return this;
            }
            return this.merge(that, Merge.of(merges));
        }

        default public @NonNull Builder merge(@NonNull Style that, @NonNull Merge.Strategy strategy, Merge ... merges) {
            if (merges.length == 0) {
                return this;
            }
            return this.merge(that, strategy, Merge.of(merges));
        }

        default public @NonNull Builder merge(@NonNull Style that, @NonNull Set<Merge> merges) {
            return this.merge(that, Merge.Strategy.ALWAYS, merges);
        }

        public @NonNull Builder merge(@NonNull Style var1, @NonNull Merge.Strategy var2, @NonNull Set<Merge> var3);

        default public @NonNull Builder apply(@NonNull StyleBuilderApplicable applicable) {
            applicable.styleApply(this);
            return this;
        }

        @Override
        public @NonNull Style build();
    }

    public static enum Merge {
        COLOR,
        DECORATIONS,
        EVENTS,
        INSERTION,
        FONT;

        static final Set<Merge> ALL;
        static final Set<Merge> COLOR_AND_DECORATIONS;

        public static @NonNull Set<Merge> all() {
            return ALL;
        }

        public static @NonNull Set<Merge> colorAndDecorations() {
            return COLOR_AND_DECORATIONS;
        }

        public static @NonNull Set<Merge> of(Merge ... merges) {
            return ShadyPines.enumSet(Merge.class, (Enum[])merges);
        }

        static boolean hasAll(@NonNull Set<Merge> merges) {
            return merges.size() == ALL.size();
        }

        static {
            ALL = Merge.of(Merge.values());
            COLOR_AND_DECORATIONS = Merge.of(COLOR, DECORATIONS);
        }

        public static enum Strategy {
            ALWAYS,
            NEVER,
            IF_ABSENT_ON_TARGET;

        }
    }
}

