/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.format;

import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.format.NamedTextColor;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.format.Style;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.format.StyleBuilderApplicable;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.format.TextColorImpl;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.format.TextFormat;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.util.RGBLike;
import ca.stellardrift.permissionsex.ext.net.kyori.examination.Examinable;
import ca.stellardrift.permissionsex.ext.net.kyori.examination.ExaminableProperty;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.value.qual.IntRange;

public interface TextColor
extends Comparable<TextColor>,
Examinable,
RGBLike,
StyleBuilderApplicable,
TextFormat {
    public static @NonNull TextColor color(int value) {
        NamedTextColor named = NamedTextColor.ofExact(value);
        return named != null ? named : new TextColorImpl(value);
    }

    public static @NonNull TextColor color(RGBLike rgb) {
        return TextColor.color(rgb.red(), rgb.green(), rgb.blue());
    }

    public static @NonNull TextColor color(@IntRange(from=0L, to=255L) int r, @IntRange(from=0L, to=255L) int g, @IntRange(from=0L, to=255L) int b) {
        return TextColor.color((r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF);
    }

    public static @NonNull TextColor color(float r, float g, float b) {
        return TextColor.color((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    public static @Nullable TextColor fromHexString(@NonNull String string) {
        if (string.startsWith("#")) {
            try {
                int hex = Integer.parseInt(string.substring(1), 16);
                return TextColor.color(hex);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public static @Nullable TextColor fromCSSHexString(@NonNull String string) {
        if (string.startsWith("#")) {
            int hex;
            String hexString = string.substring(1);
            if (hexString.length() != 3 && hexString.length() != 6) {
                return null;
            }
            try {
                hex = Integer.parseInt(hexString, 16);
            }
            catch (NumberFormatException e) {
                return null;
            }
            if (hexString.length() == 6) {
                return TextColor.color(hex);
            }
            int red = (hex & 0xF00) >> 8 | (hex & 0xF00) >> 4;
            int green = (hex & 0xF0) >> 4 | hex & 0xF0;
            int blue = (hex & 0xF) << 4 | hex & 0xF;
            return TextColor.color(red, green, blue);
        }
        return null;
    }

    public int value();

    default public @NonNull String asHexString() {
        return String.format("#%06x", this.value());
    }

    @Override
    default public @IntRange(from=0L, to=255L) int red() {
        return this.value() >> 16 & 0xFF;
    }

    @Override
    default public @IntRange(from=0L, to=255L) int green() {
        return this.value() >> 8 & 0xFF;
    }

    @Override
    default public @IntRange(from=0L, to=255L) int blue() {
        return this.value() & 0xFF;
    }

    @Override
    default public void styleApply(@NonNull Style.Builder style) {
        style.color(this);
    }

    @Override
    default public int compareTo(TextColor that) {
        return Integer.compare(this.value(), that.value());
    }

    @Override
    default public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("value", this.asHexString()));
    }
}

