/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.renderer;

import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.BlockNBTComponent;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.BuildableComponent;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.ComponentBuilder;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.EntityNBTComponent;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.KeybindComponent;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.NBTComponent;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.NBTComponentBuilder;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.ScoreComponent;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.SelectorComponent;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.StorageNBTComponent;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.TextComponent;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.TranslatableComponent;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.event.HoverEvent;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.format.Style;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.renderer.AbstractComponentRenderer;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.translation.Translator;
import java.text.AttributedCharacterIterator;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class TranslatableComponentRenderer<C>
extends AbstractComponentRenderer<C> {
    private static final Set<Style.Merge> MERGES = Style.Merge.of(Style.Merge.COLOR, Style.Merge.DECORATIONS, Style.Merge.INSERTION, Style.Merge.FONT);

    public static @NonNull TranslatableComponentRenderer<Locale> usingTranslationSource(final @NonNull Translator source) {
        Objects.requireNonNull(source, "source");
        return new TranslatableComponentRenderer<Locale>(){

            @Override
            protected @Nullable MessageFormat translate(@NonNull String key, @NonNull Locale context) {
                return source.translate(key, context);
            }
        };
    }

    protected abstract @Nullable MessageFormat translate(@NonNull String var1, @NonNull C var2);

    @Override
    protected @NonNull Component renderBlockNbt(@NonNull BlockNBTComponent component, @NonNull C context) {
        BlockNBTComponent.Builder builder = TranslatableComponentRenderer.nbt(Component.blockNBT(), component).pos(component.pos());
        return this.mergeStyleAndOptionallyDeepRender(component, builder, context);
    }

    @Override
    protected @NonNull Component renderEntityNbt(@NonNull EntityNBTComponent component, @NonNull C context) {
        EntityNBTComponent.Builder builder = TranslatableComponentRenderer.nbt(Component.entityNBT(), component).selector(component.selector());
        return this.mergeStyleAndOptionallyDeepRender(component, builder, context);
    }

    @Override
    protected @NonNull Component renderStorageNbt(@NonNull StorageNBTComponent component, @NonNull C context) {
        StorageNBTComponent.Builder builder = TranslatableComponentRenderer.nbt(Component.storageNBT(), component).storage(component.storage());
        return this.mergeStyleAndOptionallyDeepRender(component, builder, context);
    }

    protected static <C extends NBTComponent<C, B>, B extends NBTComponentBuilder<C, B>> B nbt(B builder, C oldComponent) {
        return builder.nbtPath(oldComponent.nbtPath()).interpret(oldComponent.interpret());
    }

    @Override
    protected @NonNull Component renderKeybind(@NonNull KeybindComponent component, @NonNull C context) {
        KeybindComponent.Builder builder = Component.keybind().keybind(component.keybind());
        return this.mergeStyleAndOptionallyDeepRender(component, builder, context);
    }

    @Override
    protected @NonNull Component renderScore(@NonNull ScoreComponent component, @NonNull C context) {
        ScoreComponent.Builder builder = Component.score().name(component.name()).objective(component.objective()).value(component.value());
        return this.mergeStyleAndOptionallyDeepRender(component, builder, context);
    }

    @Override
    protected @NonNull Component renderSelector(@NonNull SelectorComponent component, @NonNull C context) {
        SelectorComponent.Builder builder = Component.selector().pattern(component.pattern());
        return this.mergeStyleAndOptionallyDeepRender(component, builder, context);
    }

    @Override
    protected @NonNull Component renderText(@NonNull TextComponent component, @NonNull C context) {
        TextComponent.Builder builder = Component.text().content(component.content());
        return this.mergeStyleAndOptionallyDeepRender(component, builder, context);
    }

    @Override
    protected @NonNull Component renderTranslatable(@NonNull TranslatableComponent component, @NonNull C context) {
        @Nullable MessageFormat format = this.translate(component.key(), context);
        if (format == null) {
            TranslatableComponent.Builder builder = Component.translatable().key(component.key());
            if (!component.args().isEmpty()) {
                ArrayList<Component> args2 = new ArrayList<Component>(component.args());
                int size = args2.size();
                for (int i = 0; i < size; ++i) {
                    args2.set(i, this.render((Component)args2.get(i), context));
                }
                builder.args(args2);
            }
            return this.mergeStyleAndOptionallyDeepRender(component, builder, context);
        }
        List<Component> args3 = component.args();
        TextComponent.Builder builder = Component.text();
        this.mergeStyle(component, builder, context);
        if (args3.isEmpty()) {
            builder.content(format.format(null, new StringBuffer(), null).toString());
            return this.optionallyRenderChildrenAppendAndBuild(component.children(), builder, context);
        }
        Object[] nulls = new Object[args3.size()];
        StringBuffer sb = format.format(nulls, new StringBuffer(), (FieldPosition)null);
        AttributedCharacterIterator it = format.formatToCharacterIterator(nulls);
        while (it.getIndex() < it.getEndIndex()) {
            int end = it.getRunLimit();
            Integer index = (Integer)it.getAttribute(MessageFormat.Field.ARGUMENT);
            if (index != null) {
                builder.append(this.render(args3.get(index), context));
            } else {
                builder.append((Component)Component.text(sb.substring(it.getIndex(), end)));
            }
            it.setIndex(end);
        }
        return this.optionallyRenderChildrenAppendAndBuild(component.children(), builder, context);
    }

    protected <O extends BuildableComponent<O, B>, B extends ComponentBuilder<O, B>> O mergeStyleAndOptionallyDeepRender(Component component, B builder, C context) {
        this.mergeStyle(component, builder, context);
        return this.optionallyRenderChildrenAppendAndBuild(component.children(), builder, context);
    }

    protected <O extends BuildableComponent<O, B>, B extends ComponentBuilder<O, B>> O optionallyRenderChildrenAppendAndBuild(List<Component> children, B builder, C context) {
        if (!children.isEmpty()) {
            children.forEach(child -> builder.append(this.render((Component)child, context)));
        }
        return (O)builder.build();
    }

    protected <B extends ComponentBuilder<?, ?>> void mergeStyle(Component component, B builder, C context) {
        builder.mergeStyle(component, MERGES);
        builder.clickEvent(component.clickEvent());
        @Nullable HoverEvent<?> hoverEvent = component.hoverEvent();
        if (hoverEvent != null) {
            builder.hoverEvent(hoverEvent.withRenderedValue(this, context));
        }
    }
}

