/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.serializer.gson;

import ca.stellardrift.permissionsex.ext.net.kyori.adventure.key.Key;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.event.HoverEvent;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ShowEntitySerializer
implements JsonDeserializer<HoverEvent.ShowEntity>,
JsonSerializer<HoverEvent.ShowEntity> {
    static final String TYPE = "type";
    static final String ID = "id";
    static final String NAME = "name";

    ShowEntitySerializer() {
    }

    public HoverEvent.ShowEntity deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        if (!object.has(TYPE) || !object.has(ID)) {
            throw new JsonParseException("A show entity hover event needs type and id fields to be deserialized");
        }
        Key type = (Key)context.deserialize((JsonElement)object.getAsJsonPrimitive(TYPE), Key.class);
        UUID id = UUID.fromString(object.getAsJsonPrimitive(ID).getAsString());
        Component name = null;
        if (object.has(NAME)) {
            name = (Component)context.deserialize(object.get(NAME), Component.class);
        }
        return HoverEvent.ShowEntity.of(type, id, name);
    }

    public JsonElement serialize(HoverEvent.ShowEntity src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.add(TYPE, context.serialize((Object)src.type()));
        json.addProperty(ID, src.id().toString());
        @Nullable Component name = src.name();
        if (name != null) {
            json.add(NAME, context.serialize((Object)name));
        }
        return json;
    }
}

