/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.org.spongepowered.configurate;

import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.AbstractConfigurationNode;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.ConfigValue;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.ScopedConfigurationNode;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.serialize.Scalars;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.util.UnmodifiableCollections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ListConfigValue<N extends ScopedConfigurationNode<N>, T extends AbstractConfigurationNode<N, T>>
extends ConfigValue<N, T> {
    static final Object UNALLOCATED_IDX = new Object(){

        public String toString() {
            return "<list unallocated>";
        }
    };
    final AtomicReference<@NonNull List<T>> values = new AtomicReference(new ArrayList());

    static boolean likelyListKey(@Nullable Object key) {
        return key instanceof Integer || key == UNALLOCATED_IDX;
    }

    ListConfigValue(T holder) {
        super(holder);
    }

    ListConfigValue(T holder, @Nullable Object startValue) {
        super(holder);
        if (startValue != null) {
            Object child = ((AbstractConfigurationNode)holder).createNode(0);
            ((AbstractConfigurationNode)child).attached = true;
            ((AbstractConfigurationNode)child).raw(startValue);
            this.values.get().add(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get() {
        List<T> values;
        List<T> list = values = this.values.get();
        synchronized (list) {
            ArrayList<Object> ret = new ArrayList<Object>(values.size());
            for (AbstractConfigurationNode obj : values) {
                ret.add(obj.raw());
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<N> unwrapped() {
        List<T> orig;
        List<T> list = orig = this.values.get();
        synchronized (list) {
            ArrayList ret = new ArrayList(orig.size());
            for (AbstractConfigurationNode element : orig) {
                ret.add(element.self());
            }
            return Collections.unmodifiableList(ret);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void set(@Nullable Object value) {
        if (!(value instanceof Collection)) {
            value = Collections.singleton(value);
        }
        @Nullable Collection valueAsList = value;
        ArrayList newValue = new ArrayList(valueAsList.size());
        int count = 0;
        for (Object o : valueAsList) {
            if (o == null) continue;
            Object child = this.holder.createNode(count);
            newValue.add(count, child);
            ((AbstractConfigurationNode)child).attached = true;
            ((AbstractConfigurationNode)child).raw(o);
            ++count;
        }
        ListConfigValue.detachNodes(this.values.getAndSet(newValue));
    }

    @Override
    @Nullable T putChild(Object key, @Nullable T value) {
        return this.putChildInternal(key, value, false);
    }

    @Override
    @Nullable T putChildIfAbsent(Object key, @Nullable T value) {
        return this.putChildInternal(key, value, true);
    }

    private @Nullable T putChildInternal(Object index, @Nullable T value, boolean onlyIfAbsent) {
        if (index == UNALLOCATED_IDX) {
            if (value != null) {
                List<T> values;
                do {
                    values = this.values.get();
                    values.add(value);
                    ((AbstractConfigurationNode)value).key = values.lastIndexOf(value);
                } while (!this.values.compareAndSet(values, values));
            }
            return null;
        }
        return this.putChildInternal((Integer)index, value, onlyIfAbsent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable T putChildInternal(int index, @Nullable T value, boolean onlyIfAbsent) {
        List<T> values;
        AbstractConfigurationNode ret = null;
        do {
            List<T> list = values = this.values.get();
            synchronized (list) {
                if (value == null) {
                    if (index >= 0 && index < values.size()) {
                        ret = (AbstractConfigurationNode)values.remove(index);
                        for (int i = index; i < values.size(); ++i) {
                            ((AbstractConfigurationNode)values.get((int)i)).key = index;
                        }
                    }
                } else if (index >= 0 && index < values.size()) {
                    if (onlyIfAbsent) {
                        return (T)((AbstractConfigurationNode)values.get(index));
                    }
                    ret = (AbstractConfigurationNode)values.set(index, value);
                } else {
                    values.add(index, value);
                }
            }
        } while (!this.values.compareAndSet(values, values));
        return (T)ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable T child(@Nullable Object key) {
        List<T> values;
        @Nullable Integer value = Scalars.INTEGER.tryDeserialize(key);
        if (value == null || value < 0) {
            return null;
        }
        List<T> list = values = this.values.get();
        synchronized (list) {
            if (value >= values.size()) {
                return null;
            }
            return (T)((AbstractConfigurationNode)values.get(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<T> iterateChildren() {
        List<T> values;
        List<T> list = values = this.values.get();
        synchronized (list) {
            return UnmodifiableCollections.copyOf(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ListConfigValue<N, T> copy(T holder) {
        ArrayList<T> copyValues;
        List<T> values;
        ListConfigValue<N, T> copy = new ListConfigValue<N, T>(holder);
        List<T> list = values = this.values.get();
        synchronized (list) {
            copyValues = new ArrayList<T>(values.size());
            for (AbstractConfigurationNode obj : values) {
                copyValues.add(obj.copy(holder));
            }
        }
        copy.values.set(copyValues);
        return copy;
    }

    @Override
    boolean isEmpty() {
        return this.values.get().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void detachNodes(List<? extends AbstractConfigurationNode<?, ?>> children) {
        List<AbstractConfigurationNode<?, ?>> list = children;
        synchronized (list) {
            for (AbstractConfigurationNode<?, ?> node : children) {
                node.attached = false;
                node.clear();
            }
        }
    }

    @Override
    public void clear() {
        List oldValues = this.values.getAndSet(new ArrayList());
        ListConfigValue.detachNodes(oldValues);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ListConfigValue)) {
            return false;
        }
        ListConfigValue that = (ListConfigValue)other;
        return Objects.equals(this.values.get(), that.values.get());
    }

    public int hashCode() {
        return this.values.get().hashCode();
    }

    public String toString() {
        return "ListConfigValue{values=" + this.values.get().toString() + '}';
    }
}

