/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.org.spongepowered.configurate;

import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.AbstractConfigurationNode;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.ConfigValue;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.ScopedConfigurationNode;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.checkerframework.checker.nullness.qual.Nullable;

final class MapConfigValue<N extends ScopedConfigurationNode<N>, A extends AbstractConfigurationNode<N, A>>
extends ConfigValue<N, A> {
    volatile Map<Object, A> values = this.newMap();

    MapConfigValue(A holder) {
        super(holder);
    }

    private Map<Object, A> newMap() {
        Map ret = this.holder.options().mapFactory().create();
        if (!(ret instanceof ConcurrentMap)) {
            return Collections.synchronizedMap(ret);
        }
        return ret;
    }

    @Override
    public @Nullable Object get() {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        for (Map.Entry<Object, A> ent : this.values.entrySet()) {
            value.put(ent.getKey(), ((AbstractConfigurationNode)ent.getValue()).raw());
        }
        return value;
    }

    public Map<Object, N> unwrapped() {
        LinkedHashMap unwrapped = new LinkedHashMap();
        this.values.forEach((k, v) -> unwrapped.put(k, v.self()));
        return Collections.unmodifiableMap(unwrapped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(@Nullable Object value) {
        if (value instanceof Map) {
            Map<Object, A> newValue = this.newMap();
            for (Map.Entry ent : ((Map)value).entrySet()) {
                if (ent.getValue() == null) continue;
                Object child = this.holder.createNode(ent.getKey());
                newValue.put(ent.getKey(), child);
                ((AbstractConfigurationNode)child).attached = true;
                ((AbstractConfigurationNode)child).raw(ent.getValue());
            }
            MapConfigValue mapConfigValue = this;
            synchronized (mapConfigValue) {
                Map<Object, A> oldMap = this.values;
                this.values = newValue;
                MapConfigValue.detachChildren(oldMap);
            }
        } else {
            throw new IllegalArgumentException("Map configuration values can only be set to values of type Map");
        }
    }

    @Override
    @Nullable A putChild(Object key, @Nullable A value) {
        if (value == null) {
            return (A)((AbstractConfigurationNode)this.values.remove(key));
        }
        return (A)((AbstractConfigurationNode)this.values.put(key, value));
    }

    @Override
    @Nullable A putChildIfAbsent(Object key, @Nullable A value) {
        if (value == null) {
            return (A)((AbstractConfigurationNode)this.values.remove(key));
        }
        return (A)((AbstractConfigurationNode)this.values.putIfAbsent(key, value));
    }

    @Override
    public @Nullable A child(@Nullable Object key) {
        return (A)((AbstractConfigurationNode)this.values.get(key));
    }

    @Override
    public Iterable<A> iterateChildren() {
        return this.values.values();
    }

    @Override
    MapConfigValue<N, A> copy(A holder) {
        MapConfigValue<N, A> copy = new MapConfigValue<N, A>(holder);
        for (Map.Entry<Object, A> ent : this.values.entrySet()) {
            copy.values.put(ent.getKey(), ((AbstractConfigurationNode)ent.getValue()).copy(holder));
        }
        return copy;
    }

    @Override
    boolean isEmpty() {
        return this.values.isEmpty();
    }

    private static void detachChildren(Map<Object, ? extends AbstractConfigurationNode<?, ?>> map) {
        for (AbstractConfigurationNode<?, ?> value : map.values()) {
            value.attached = false;
            value.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        MapConfigValue mapConfigValue = this;
        synchronized (mapConfigValue) {
            Map<Object, A> oldMap = this.values;
            this.values = this.newMap();
            MapConfigValue.detachChildren(oldMap);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MapConfigValue)) {
            return false;
        }
        MapConfigValue that = (MapConfigValue)other;
        return Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public String toString() {
        return "MapConfigValue{values=" + this.values + '}';
    }
}

