/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.gson;

import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.BasicConfigurationNode;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.ConfigurateException;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.ConfigurationNode;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.ConfigurationOptions;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.gson.GsonVisitor;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.gson.JsonReaderAccess;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.loader.AbstractConfigurationLoader;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.loader.CommentHandler;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.loader.CommentHandlers;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.loader.ParsingException;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.util.Strings;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.util.UnmodifiableCollections;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.gson.stream.MalformedJsonException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class GsonConfigurationLoader
extends AbstractConfigurationLoader<BasicConfigurationNode> {
    private static final Set<Class<?>> NATIVE_TYPES = UnmodifiableCollections.toSet(Double.class, Float.class, Long.class, Integer.class, Boolean.class, String.class);
    private final boolean lenient;
    private final String indent;

    public static @NonNull Builder builder() {
        return new Builder();
    }

    private GsonConfigurationLoader(Builder builder) {
        super(builder, new CommentHandler[]{CommentHandlers.DOUBLE_SLASH, CommentHandlers.SLASH_BLOCK, CommentHandlers.HASH});
        this.lenient = builder.lenient();
        this.indent = Strings.repeat(" ", builder.indent());
    }

    @Override
    protected void loadInternal(BasicConfigurationNode node, BufferedReader reader) throws ParsingException {
        try {
            reader.mark(1);
            if (reader.read() == -1) {
                return;
            }
            reader.reset();
        }
        catch (IOException ex) {
            throw new ParsingException(node, 0, 0, null, "peeking file size", ex);
        }
        try (JsonReader parser = new JsonReader((Reader)reader);){
            parser.setLenient(this.lenient);
            this.parseValue(parser, node);
        }
        catch (IOException ex) {
            throw ParsingException.wrap(node, ex);
        }
    }

    private void parseValue(JsonReader parser, BasicConfigurationNode node) throws ParsingException {
        JsonToken token;
        try {
            token = parser.peek();
        }
        catch (IOException ex) {
            throw this.newException(parser, node, ex.getMessage(), ex);
        }
        try {
            switch (token) {
                case BEGIN_OBJECT: {
                    this.parseObject(parser, node);
                    break;
                }
                case BEGIN_ARRAY: {
                    this.parseArray(parser, node);
                    break;
                }
                case NUMBER: {
                    node.raw(this.readNumber(parser));
                    break;
                }
                case STRING: {
                    node.raw(parser.nextString());
                    break;
                }
                case BOOLEAN: {
                    node.raw(parser.nextBoolean());
                    break;
                }
                case NULL: {
                    parser.nextNull();
                    node.raw(null);
                    break;
                }
                case NAME: {
                    break;
                }
                default: {
                    throw this.newException(parser, node, "Unsupported token type: " + token, null);
                }
            }
        }
        catch (JsonParseException | MalformedJsonException ex) {
            throw this.newException(parser, node, ex.getMessage(), ex.getCause());
        }
        catch (ParsingException ex) {
            ex.initPath(node::path);
            throw ex;
        }
        catch (IOException ex) {
            throw this.newException(parser, node, "An underlying exception occurred", ex);
        }
    }

    private ParsingException newException(JsonReader reader, ConfigurationNode node, @Nullable String message, @Nullable Throwable cause) {
        return new ParsingException(node, JsonReaderAccess.lineNumber(reader), JsonReaderAccess.column(reader), null, message, cause);
    }

    private Number readNumber(JsonReader reader) throws IOException {
        String number = reader.nextString();
        if (number.contains(".")) {
            return Double.parseDouble(number);
        }
        long nextLong = Long.parseLong(number);
        int nextInt = (int)nextLong;
        if ((long)nextInt == nextLong) {
            return nextInt;
        }
        return nextLong;
    }

    private void parseArray(JsonReader parser, BasicConfigurationNode node) throws IOException {
        JsonToken token;
        parser.beginArray();
        boolean written = false;
        while ((token = parser.peek()) != null) {
            if (token == JsonToken.END_ARRAY) {
                parser.endArray();
                if (!written) {
                    node.raw(Collections.emptyList());
                }
                return;
            }
            this.parseValue(parser, (BasicConfigurationNode)node.appendListNode());
            written = true;
        }
        throw this.newException(parser, node, "Reached end of stream with unclosed array!", null);
    }

    private void parseObject(JsonReader parser, BasicConfigurationNode node) throws ParsingException, IOException {
        JsonToken token;
        parser.beginObject();
        boolean written = false;
        block4: while ((token = parser.peek()) != null) {
            switch (token) {
                case END_OBJECT: 
                case END_DOCUMENT: {
                    parser.endObject();
                    if (!written) {
                        node.raw(Collections.emptyMap());
                    }
                    return;
                }
                case NAME: {
                    this.parseValue(parser, (BasicConfigurationNode)node.node(new Object[]{parser.nextName()}));
                    written = true;
                    continue block4;
                }
            }
            throw new JsonParseException("Received improper object value " + token);
        }
        throw new JsonParseException("Reached end of stream with unclosed object!");
    }

    @Override
    protected void saveInternal(ConfigurationNode node, Writer writer) throws ConfigurateException {
        if (!this.lenient && !node.isMap()) {
            throw new ConfigurateException(node, "Non-lenient json generators must have children of map type");
        }
        try (JsonWriter generator = new JsonWriter(writer);){
            generator.setIndent(this.indent);
            generator.setLenient(this.lenient);
            node.visit(GsonVisitor.INSTANCE.get(), generator);
            writer.write(SYSTEM_LINE_SEPARATOR);
        }
        catch (IOException ex) {
            throw ConfigurateException.wrap(node, ex);
        }
    }

    @Override
    public BasicConfigurationNode createNode(ConfigurationOptions options2) {
        return BasicConfigurationNode.root(options2.nativeTypes(NATIVE_TYPES));
    }

    public static final class Builder
    extends AbstractConfigurationLoader.Builder<Builder, GsonConfigurationLoader> {
        private boolean lenient = true;
        private int indent = 2;

        Builder() {
        }

        public @NonNull Builder indent(int indent) {
            this.indent = indent;
            return this;
        }

        public int indent() {
            return this.indent;
        }

        public @NonNull Builder lenient(boolean lenient) {
            this.lenient = lenient;
            return this;
        }

        public boolean lenient() {
            return this.lenient;
        }

        @Override
        public @NonNull GsonConfigurationLoader build() {
            this.defaultOptions(o -> o.nativeTypes(NATIVE_TYPES));
            return new GsonConfigurationLoader(this);
        }
    }
}

