/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.transformation;

import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.ConfigurateException;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.ConfigurationNode;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.NodePath;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.transformation.ChainedConfigurationTransformation;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.transformation.MoveStrategy;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.transformation.NodePathComparator;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.transformation.SingleConfigurationTransformation;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.transformation.TransformAction;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.transformation.VersionedTransformation;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;

@FunctionalInterface
public interface ConfigurationTransformation {
    public static final Object WILDCARD_OBJECT = new Object();

    public static ConfigurationTransformation empty() {
        return node -> {};
    }

    public static Builder builder() {
        return new Builder();
    }

    public static VersionedBuilder versionedBuilder() {
        return new VersionedBuilder();
    }

    public static ConfigurationTransformation chain(ConfigurationTransformation ... transformations) {
        if (Objects.requireNonNull(transformations, "transformations").length == 0) {
            throw new IllegalArgumentException("Cannot chain an empty array of transformations!");
        }
        if (transformations.length == 1) {
            return transformations[0];
        }
        return new ChainedConfigurationTransformation(transformations);
    }

    public void apply(ConfigurationNode var1) throws ConfigurateException;

    public static interface Versioned
    extends ConfigurationTransformation {
        public static final int VERSION_UNKNOWN = -1;

        public NodePath versionKey();

        public int latestVersion();

        default public int version(ConfigurationNode node) {
            return node.node(this.versionKey()).getInt(-1);
        }
    }

    public static final class VersionedBuilder {
        private NodePath versionKey = NodePath.path("version");
        private final NavigableMap<Integer, ConfigurationTransformation> versions = new TreeMap<Integer, ConfigurationTransformation>();

        VersionedBuilder() {
        }

        public VersionedBuilder versionKey(Object ... versionKey) {
            this.versionKey = NodePath.of(versionKey);
            return this;
        }

        public @NonNull VersionedBuilder addVersion(int version, @NonNull ConfigurationTransformation transformation) {
            if (version < 0) {
                throw new IllegalArgumentException("Version must be at least 0");
            }
            if (this.versions.putIfAbsent(version, Objects.requireNonNull(transformation, "transformation")) != null) {
                throw new IllegalArgumentException("Version '" + version + "' has been specified multiple times.");
            }
            return this;
        }

        public @NonNull VersionedBuilder addVersion(int version, ConfigurationTransformation ... transformations) {
            return this.addVersion(version, ConfigurationTransformation.chain(transformations));
        }

        public @NonNull VersionedBuilder makeVersion(int version, @NonNull Consumer<? super Builder> maker) {
            Builder builder = ConfigurationTransformation.builder();
            maker.accept(builder);
            return this.addVersion(version, builder.build());
        }

        public @NonNull Versioned build() {
            if (this.versions.isEmpty()) {
                throw new IllegalArgumentException("At least one version must be specified to build a transformation");
            }
            return new VersionedTransformation(this.versionKey, this.versions);
        }
    }

    public static final class Builder {
        private MoveStrategy strategy = MoveStrategy.OVERWRITE;
        private final NavigableMap<NodePath, TransformAction> actions = new TreeMap<NodePath, TransformAction>(NodePathComparator.INSTANCE);

        Builder() {
        }

        public Builder addAction(NodePath path, TransformAction action) {
            this.actions.put(Objects.requireNonNull(path, "path"), Objects.requireNonNull(action, "action"));
            return this;
        }

        public MoveStrategy moveStrategy() {
            return this.strategy;
        }

        public Builder moveStrategy(MoveStrategy strategy) {
            this.strategy = Objects.requireNonNull(strategy, "strategy");
            return this;
        }

        public ConfigurationTransformation build() {
            if (this.actions.isEmpty()) {
                throw new IllegalArgumentException("At least one action must be specified to build a transformation");
            }
            return new SingleConfigurationTransformation(this.actions, this.strategy);
        }
    }
}

