/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.util;

import ca.stellardrift.permissionsex.ext.io.leangen.geantyref.GenericTypeReflector;
import ca.stellardrift.permissionsex.ext.io.leangen.geantyref.TypeFactory;
import ca.stellardrift.permissionsex.ext.io.leangen.geantyref.TypeToken;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.util.UnmodifiableCollections;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Types {
    private static final Map<Type, Type> BOXED_TO_PRIMITIVE = UnmodifiableCollections.buildMap(m -> {
        m.put(Boolean.class, Boolean.TYPE);
        m.put(Byte.class, Byte.TYPE);
        m.put(Short.class, Short.TYPE);
        m.put(Integer.class, Integer.TYPE);
        m.put(Long.class, Long.TYPE);
        m.put(Float.class, Float.TYPE);
        m.put(Double.class, Double.TYPE);
        m.put(Void.class, Void.TYPE);
    });
    private static final Map<Type, Type> PRIMITIVE_TO_BOXED = UnmodifiableCollections.buildMap(m -> {
        m.put(Boolean.TYPE, Boolean.class);
        m.put(Byte.TYPE, Byte.class);
        m.put(Short.TYPE, Short.class);
        m.put(Integer.TYPE, Integer.class);
        m.put(Long.TYPE, Long.class);
        m.put(Float.TYPE, Float.class);
        m.put(Double.TYPE, Double.class);
        m.put(Void.TYPE, Void.class);
    });

    private Types() {
    }

    public static boolean isArray(Type input) {
        if (input instanceof Class) {
            return ((Class)input).isArray();
        }
        if (input instanceof ParameterizedType) {
            return Types.isArray(((ParameterizedType)input).getRawType());
        }
        return input instanceof GenericArrayType;
    }

    public static boolean isBoxedPrimitive(Type input) {
        return BOXED_TO_PRIMITIVE.containsKey(input);
    }

    public static Type unbox(Type input) {
        Type ret = BOXED_TO_PRIMITIVE.get(input);
        return ret == null ? input : ret;
    }

    public static Type box(Type input) {
        Type ret = PRIMITIVE_TO_BOXED.get(input);
        return ret == null ? input : ret;
    }

    public static <T> TypeToken<List<T>> makeListType(TypeToken<T> elementType) {
        return TypeToken.get(TypeFactory.parameterizedClass(List.class, elementType.getType()));
    }

    public static AnnotatedElement combinedAnnotations(AnnotatedElement ... elements) {
        return new CombinedAnnotations(Arrays.copyOf(elements, elements.length));
    }

    public static Type requireCompleteParameters(Type input) {
        if (GenericTypeReflector.isMissingTypeParameters(input)) {
            throw new IllegalArgumentException("Provided type " + input + " is a raw type, which is not accepted.");
        }
        return input;
    }

    public static Stream<Type> allSuperTypes(Type type) {
        return Types.calculateSuperTypes(type, false);
    }

    public static Stream<Type> allSuperTypesAndInterfaces(Type type) {
        return Types.calculateSuperTypes(type, true);
    }

    private static Stream<Type> calculateSuperTypes(Type type, boolean includeInterfaces) {
        Objects.requireNonNull(type, "type");
        return StreamSupport.stream(Spliterators.spliterator(new SuperTypesIterator(type, includeInterfaces), Long.MAX_VALUE, 1280), false);
    }

    static class CombinedAnnotations
    implements AnnotatedElement {
        private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
        private final AnnotatedElement[] elements;

        CombinedAnnotations(AnnotatedElement[] elements) {
            this.elements = elements;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            for (AnnotatedElement element : this.elements) {
                if (!element.isAnnotationPresent(annotationClass)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends Annotation> @Nullable T getAnnotation(Class<T> annotationClass) {
            AnnotatedElement element;
            @Nullable T ret = null;
            AnnotatedElement[] annotatedElementArray = this.elements;
            int n = annotatedElementArray.length;
            for (int i = 0; i < n && (ret = (T)(element = annotatedElementArray[i]).getAnnotation(annotationClass)) == null; ++i) {
            }
            return ret;
        }

        @Override
        public Annotation[] getAnnotations() {
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            for (AnnotatedElement element : this.elements) {
                Annotation[] annotation = element.getAnnotations();
                if (annotation.length <= 0) continue;
                annotations.addAll(Arrays.asList(annotation));
            }
            return annotations.toArray(EMPTY_ANNOTATION_ARRAY);
        }

        @Override
        public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            for (AnnotatedElement element : this.elements) {
                Annotation[] annotation = element.getAnnotationsByType(annotationClass);
                if (annotation.length <= 0) continue;
                annotations.addAll(Arrays.asList(annotation));
            }
            return annotations.toArray(EMPTY_ANNOTATION_ARRAY);
        }

        @Override
        public <T extends Annotation> @Nullable T getDeclaredAnnotation(Class<T> annotationClass) {
            AnnotatedElement element;
            @Nullable T ret = null;
            AnnotatedElement[] annotatedElementArray = this.elements;
            int n = annotatedElementArray.length;
            for (int i = 0; i < n && (ret = (T)(element = annotatedElementArray[i]).getDeclaredAnnotation(annotationClass)) == null; ++i) {
            }
            return ret;
        }

        @Override
        public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> annotationClass) {
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            for (AnnotatedElement element : this.elements) {
                Annotation[] annotation = element.getDeclaredAnnotationsByType(annotationClass);
                if (annotation.length <= 0) continue;
                annotations.addAll(Arrays.asList(annotation));
            }
            return annotations.toArray(EMPTY_ANNOTATION_ARRAY);
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            for (AnnotatedElement element : this.elements) {
                Annotation[] annotation = element.getDeclaredAnnotations();
                if (annotation.length <= 0) continue;
                annotations.addAll(Arrays.asList(annotation));
            }
            return annotations.toArray(EMPTY_ANNOTATION_ARRAY);
        }
    }

    static class SuperTypesIterator
    implements Iterator<Type> {
        private final boolean includeInterfaces;
        private final Deque<Type> types = new ArrayDeque<Type>();
        private final Set<Type> seen = new HashSet<Type>();

        SuperTypesIterator(Type base, boolean includeInterfaces) {
            this.types.add(base);
            this.includeInterfaces = includeInterfaces;
        }

        @Override
        public boolean hasNext() {
            return !this.types.isEmpty();
        }

        @Override
        public Type next() {
            Type head = this.types.removeLast();
            if (head instanceof Class && ((Class)head).isArray() || head instanceof GenericArrayType) {
                Type componentType = head instanceof Class ? ((Class)head).getComponentType() : ((GenericArrayType)head).getGenericComponentType();
                this.addSuperClassAndInterface(componentType, GenericTypeReflector.erase(componentType), TypeFactory::arrayOf);
            } else if (head instanceof Class || head instanceof ParameterizedType) {
                Class clazz;
                if (head instanceof ParameterizedType) {
                    ParameterizedType parameterized = (ParameterizedType)head;
                    clazz = (Class)parameterized.getRawType();
                } else {
                    clazz = (Class)head;
                }
                this.addSuperClassAndInterface(head, clazz, null);
            } else if (head instanceof TypeVariable) {
                this.addAllIfUnseen(head, ((TypeVariable)head).getBounds());
            } else if (head instanceof WildcardType) {
                Type[] upperBounds = ((WildcardType)head).getUpperBounds();
                if (upperBounds.length == 1) {
                    Type upperBound = upperBounds[0];
                    this.addSuperClassAndInterface(head, GenericTypeReflector.erase(upperBound), TypeFactory::wildcardExtends);
                } else {
                    this.addAllIfUnseen(head, ((WildcardType)head).getUpperBounds());
                }
            }
            return head;
        }

        private void addAllIfUnseen(Type base, Type ... types) {
            for (Type type : types) {
                this.addIfUnseen(GenericTypeReflector.resolveType(type, base));
            }
        }

        private void addIfUnseen(Type type) {
            if (this.seen.add(type)) {
                this.types.addLast(type);
            }
        }

        private void addSuperClassAndInterface(Type base, Class<?> actualClass, @Nullable UnaryOperator<Type> postProcess) {
            if (this.includeInterfaces) {
                for (Type itf : actualClass.getGenericInterfaces()) {
                    if (postProcess != null) {
                        this.addIfUnseen((Type)postProcess.apply(GenericTypeReflector.resolveType(itf, base)));
                        continue;
                    }
                    this.addIfUnseen(GenericTypeReflector.resolveType(itf, base));
                }
            }
            if (actualClass.getSuperclass() != null) {
                Type resolved = GenericTypeReflector.resolveType(actualClass.getGenericSuperclass(), base);
                this.addIfUnseen(postProcess == null ? resolved : (Type)postProcess.apply(resolved));
            }
        }
    }
}

