/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.backend;

import ca.stellardrift.permissionsex.PermissionsEngine;
import ca.stellardrift.permissionsex.context.ContextInheritance;
import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.datastore.DataStore;
import ca.stellardrift.permissionsex.datastore.DataStoreFactory;
import ca.stellardrift.permissionsex.datastore.StoreProperties;
import ca.stellardrift.permissionsex.exception.PermissionsException;
import ca.stellardrift.permissionsex.exception.PermissionsLoadingException;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.ConfigurationNode;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.serialize.SerializationException;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.util.CheckedSupplier;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.util.UnmodifiableCollections;
import ca.stellardrift.permissionsex.impl.PermissionsEx;
import ca.stellardrift.permissionsex.impl.backend.Messages;
import ca.stellardrift.permissionsex.impl.data.CacheListenerHolder;
import ca.stellardrift.permissionsex.impl.util.Util;
import ca.stellardrift.permissionsex.rank.RankLadder;
import ca.stellardrift.permissionsex.subject.ImmutableSubjectData;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractDataStore<T extends AbstractDataStore<T, C>, C>
implements DataStore {
    private @MonotonicNonNull PermissionsEx<?> manager;
    private final StoreProperties<C> properties;
    protected final CacheListenerHolder<Map.Entry<String, String>, ImmutableSubjectData> listeners = new CacheListenerHolder();
    protected final CacheListenerHolder<String, RankLadder> rankLadderListeners = new CacheListenerHolder();
    protected final CacheListenerHolder<Boolean, ContextInheritance> contextInheritanceListeners = new CacheListenerHolder();

    protected AbstractDataStore(StoreProperties<C> props) {
        this.properties = props;
    }

    @Override
    public String getName() {
        return this.properties.identifier();
    }

    protected PermissionsEngine getManager() {
        return this.manager;
    }

    protected C config() {
        return this.properties.config();
    }

    @Override
    public final boolean initialize(PermissionsEngine core) throws PermissionsLoadingException {
        this.manager = (PermissionsEx)core;
        return this.initializeInternal();
    }

    protected abstract boolean initializeInternal() throws PermissionsLoadingException;

    @Override
    public final CompletableFuture<ImmutableSubjectData> getData(String type, String identifier, @Nullable Consumer<ImmutableSubjectData> listener) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(identifier, "identifier");
        CompletableFuture<ImmutableSubjectData> ret = this.getDataInternal(type, identifier);
        ret.thenRun(() -> {
            if (listener != null) {
                this.listeners.addListener(UnmodifiableCollections.immutableMapEntry(type, identifier), listener);
            }
        });
        return ret;
    }

    @Override
    public final CompletableFuture<ImmutableSubjectData> setData(String type, String identifier, @Nullable ImmutableSubjectData data) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(identifier, "identifier");
        Map.Entry<String, String> lookupKey = UnmodifiableCollections.immutableMapEntry(type, identifier);
        return this.setDataInternal(type, identifier, data).thenApply(newData -> {
            if (newData != null) {
                this.listeners.call(lookupKey, (ImmutableSubjectData)newData);
            }
            return newData;
        });
    }

    protected <V> CompletableFuture<V> runAsync(CheckedSupplier<V, ?> supplier) {
        return Util.asyncFailableFuture(supplier, this.getManager().asyncExecutor());
    }

    protected CompletableFuture<Void> runAsync(Runnable run) {
        return CompletableFuture.runAsync(run, this.getManager().asyncExecutor());
    }

    protected final void applyDefaultData() {
        ((CompletableFuture)this.getData(PermissionsEngine.SUBJECTS_DEFAULTS.name(), PermissionsEngine.SUBJECTS_DEFAULTS.name(), null).thenApply(data -> data.setDefaultValue(Collections.singleton(new ContextValue("localip", "127.0.0.1")), 1))).thenCompose(data -> this.setData(PermissionsEngine.SUBJECTS_DEFAULTS.name(), PermissionsEngine.SUBJECTS_DEFAULTS.name(), (ImmutableSubjectData)data));
    }

    protected abstract CompletableFuture<ImmutableSubjectData> getDataInternal(String var1, String var2);

    protected abstract CompletableFuture<ImmutableSubjectData> setDataInternal(String var1, String var2, @Nullable ImmutableSubjectData var3);

    @Override
    public final Iterable<Map.Entry<String, ImmutableSubjectData>> getAll(String type) {
        Objects.requireNonNull(type, "type");
        return Iterables.transform(this.getAllIdentifiers(type), input -> UnmodifiableCollections.immutableMapEntry(input, this.getData(type, (String)input, null).join()));
    }

    public final <V> CompletableFuture<V> performBulkOperation(Function<DataStore, V> function) {
        return Util.asyncFailableFuture(() -> this.performBulkOperationSync(function), this.getManager().asyncExecutor());
    }

    @Override
    public final CompletableFuture<RankLadder> getRankLadder(String ladderName, @Nullable Consumer<RankLadder> listener) {
        Objects.requireNonNull(ladderName, "ladderName");
        CompletableFuture<RankLadder> ladder = this.getRankLadderInternal(ladderName);
        if (listener != null) {
            this.rankLadderListeners.addListener(ladderName.toLowerCase(), listener);
        }
        return ladder;
    }

    @Override
    public final CompletableFuture<RankLadder> setRankLadder(String identifier, @Nullable RankLadder ladder) {
        return this.setRankLadderInternal(identifier, ladder).thenApply(newData -> {
            if (newData != null) {
                this.rankLadderListeners.call(identifier, (RankLadder)newData);
            }
            return newData;
        });
    }

    protected abstract CompletableFuture<RankLadder> getRankLadderInternal(String var1);

    protected abstract CompletableFuture<RankLadder> setRankLadderInternal(String var1, @Nullable RankLadder var2);

    @Override
    public final CompletableFuture<ContextInheritance> getContextInheritance(@Nullable Consumer<ContextInheritance> listener) {
        CompletableFuture<ContextInheritance> inheritance = this.getContextInheritanceInternal();
        if (listener != null) {
            this.contextInheritanceListeners.addListener(true, listener);
        }
        return inheritance;
    }

    @Override
    public final CompletableFuture<ContextInheritance> setContextInheritance(ContextInheritance contextInheritance) {
        return this.setContextInheritanceInternal(contextInheritance).thenApply(newData -> {
            if (newData != null) {
                this.contextInheritanceListeners.call(true, (ContextInheritance)newData);
            }
            return newData;
        });
    }

    protected abstract CompletableFuture<ContextInheritance> getContextInheritanceInternal();

    protected abstract CompletableFuture<ContextInheritance> setContextInheritanceInternal(ContextInheritance var1);

    protected abstract <V> V performBulkOperationSync(Function<DataStore, V> var1) throws Exception;

    @Override
    public CompletableFuture<Void> moveData(String oldType, String oldIdentifier, String newType, String newIdentifier) {
        return ((CompletableFuture)this.isRegistered(oldType, oldIdentifier).thenCombine(this.isRegistered(newType, newIdentifier), (oldRegistered, newRegistered) -> {
            if (oldRegistered.booleanValue() && !newRegistered.booleanValue()) {
                return ((CompletableFuture)((CompletableFuture)this.getData(oldType, oldIdentifier, null).thenCompose(oldData -> this.setData(newType, newIdentifier, (ImmutableSubjectData)oldData))).thenCompose(newData -> this.setData(oldType, oldIdentifier, null))).thenApply(inp -> null);
            }
            return Util.failedFuture(new PermissionsException(Messages.DATASTORE_MOVE_ERROR.tr(new Object[0])));
        })).thenCompose(future -> future);
    }

    @Override
    public String serialize(ConfigurationNode node) throws PermissionsLoadingException {
        Objects.requireNonNull(node, "node");
        try {
            node.set(this.properties.config());
        }
        catch (SerializationException e) {
            throw new PermissionsLoadingException(Messages.DATASTORE_ERROR_SERIALIZE.tr(node.key()), (Throwable)e);
        }
        return this.properties.factory().name();
    }

    public static abstract class Factory<T extends AbstractDataStore<T, C>, C>
    implements DataStoreFactory {
        private final String name;
        private final Class<C> configType;
        private final Function<StoreProperties<C>, T> newInstanceSupplier;
        private final Component friendlyName;

        protected Factory(String name, Class<C> clazz, Function<StoreProperties<C>, T> newInstanceSupplier) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(clazz, "clazz");
            this.name = name;
            this.friendlyName = Component.text(name);
            this.configType = clazz;
            this.newInstanceSupplier = newInstanceSupplier;
        }

        @Override
        public Component friendlyName() {
            return this.friendlyName;
        }

        @Override
        public final String name() {
            return this.name;
        }

        @Override
        public final DataStore create(String identifier, ConfigurationNode config) throws PermissionsLoadingException {
            try {
                C dataStoreConfig = config.get(this.configType);
                return (DataStore)this.newInstanceSupplier.apply(StoreProperties.of(identifier, dataStoreConfig, this));
            }
            catch (SerializationException e) {
                throw new PermissionsLoadingException(Messages.DATASTORE_ERROR_DESERIALIZE.tr(identifier), (Throwable)e);
            }
        }
    }
}

