/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.backend.file;

import ca.stellardrift.permissionsex.context.ContextInheritance;
import ca.stellardrift.permissionsex.datastore.DataStore;
import ca.stellardrift.permissionsex.datastore.DataStoreFactory;
import ca.stellardrift.permissionsex.datastore.StoreProperties;
import ca.stellardrift.permissionsex.exception.PermissionsLoadingException;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.BasicConfigurationNode;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.ConfigurateException;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.ConfigurationNode;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.gson.GsonConfigurationLoader;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.loader.ConfigurationLoader;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.objectmapping.ConfigSerializable;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.objectmapping.meta.Comment;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.objectmapping.meta.Setting;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.reference.ConfigurationReference;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.reference.WatchServiceListener;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.serialize.SerializationException;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.transformation.ConfigurationTransformation;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.util.MapFactories;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.yaml.YamlConfigurationLoader;
import ca.stellardrift.permissionsex.impl.backend.AbstractDataStore;
import ca.stellardrift.permissionsex.impl.backend.file.FileSubjectData;
import ca.stellardrift.permissionsex.impl.backend.file.Messages;
import ca.stellardrift.permissionsex.impl.backend.file.SchemaMigrations;
import ca.stellardrift.permissionsex.impl.backend.memory.MemoryContextInheritance;
import ca.stellardrift.permissionsex.impl.rank.FixedRankLadder;
import ca.stellardrift.permissionsex.impl.util.Util;
import ca.stellardrift.permissionsex.rank.RankLadder;
import ca.stellardrift.permissionsex.subject.ImmutableSubjectData;
import com.google.auto.service.AutoService;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class FileDataStore
extends AbstractDataStore<FileDataStore, Config> {
    static final String KEY_RANK_LADDERS = "rank-ladders";
    private @MonotonicNonNull WatchServiceListener reloadService;
    private @MonotonicNonNull ConfigurationReference<BasicConfigurationNode> permissionsConfig;
    private final AtomicInteger saveSuppressed = new AtomicInteger();
    private final AtomicBoolean dirty = new AtomicBoolean();

    public FileDataStore(StoreProperties<Config> properties) {
        super(properties);
    }

    private ConfigurationReference<BasicConfigurationNode> createLoader(Path file) throws ConfigurateException {
        Function loaderFunc = path -> ((GsonConfigurationLoader.Builder)((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().defaultOptions(o -> {
            if (((Config)this.config()).alphabetizeEntries) {
                return o.mapFactory(MapFactories.sortedNatural());
            }
            return o;
        })).path((Path)path)).indent(4).lenient(true).build();
        ConfigurationReference<Object> ret = this.reloadService != null ? this.reloadService.listenToConfiguration(loaderFunc, file) : ConfigurationReference.fixed(loaderFunc.apply(file));
        ret.updates().subscribe(this::refresh);
        ret.errors().subscribe(e -> this.getManager().logger().error(Messages.FILE_ERROR_AUTORELOAD.tr(e.getKey(), ((Throwable)e.getValue()).getLocalizedMessage())));
        return ret;
    }

    private void refresh(ConfigurationNode newNode) {
        this.listeners.getAllKeys().forEach(key -> {
            try {
                this.listeners.call(key, this.getDataSync((String)key.getKey(), (String)key.getValue()));
            }
            catch (PermissionsLoadingException e) {
                this.getManager().logger().error(Messages.FILE_ERROR_SUBJECT_AUTORELOAD.tr(key.getKey(), key.getValue()));
            }
        });
        this.rankLadderListeners.getAllKeys().forEach(key -> this.rankLadderListeners.call(key, this.getRankLadderInternal((String)key).join()));
        this.contextInheritanceListeners.getAllKeys().forEach(key -> this.contextInheritanceListeners.call(key, this.getContextInheritanceInternal().join()));
        this.getManager().logger().info(Messages.FILE_RELOAD_AUTO.tr(((Config)this.config()).file));
    }

    private Path migrateLegacy(Path permissionsFile, String extension, ConfigurationLoader<?> legacyLoader, String formatName) throws PermissionsLoadingException {
        Path legacyPermissionsFile = permissionsFile;
        ((Config)this.config()).file = ((Config)this.config()).file.replace(extension, ".json");
        permissionsFile = this.getManager().baseDirectory().resolve(((Config)this.config()).file);
        try {
            this.permissionsConfig = this.createLoader(permissionsFile);
            this.permissionsConfig.save((ConfigurationNode)legacyLoader.load());
            Files.move(legacyPermissionsFile, legacyPermissionsFile.resolveSibling(legacyPermissionsFile.getFileName().toString() + ".legacy-backup"), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new PermissionsLoadingException(Messages.FILE_ERROR_LEGACY_MIGRATION.tr(formatName, legacyPermissionsFile), (Throwable)e);
        }
        return permissionsFile;
    }

    @Override
    protected boolean initializeInternal() throws PermissionsLoadingException {
        if (((Config)this.config()).autoReload) {
            try {
                this.reloadService = WatchServiceListener.builder().taskExecutor(this.getManager().asyncExecutor()).build();
            }
            catch (IOException e) {
                throw new PermissionsLoadingException(e);
            }
        }
        String rawFile = ((Config)this.config()).file;
        Path permissionsFile = this.getManager().baseDirectory().resolve(rawFile);
        if (rawFile.endsWith(".yml")) {
            permissionsFile = this.migrateLegacy(permissionsFile, ".yml", ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(permissionsFile)).build(), "YML");
        } else if (rawFile.endsWith(".conf")) {
            permissionsFile = this.migrateLegacy(permissionsFile, ".conf", ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(permissionsFile)).build(), "HOCON");
        } else {
            try {
                this.permissionsConfig = this.createLoader(permissionsFile);
            }
            catch (ConfigurateException e) {
                throw new PermissionsLoadingException(Messages.FILE_ERROR_LOAD.tr(permissionsFile), (Throwable)e);
            }
        }
        if (this.permissionsConfig.node().childrenMap().isEmpty()) {
            try {
                this.performBulkOperationSync((Function)input -> {
                    this.applyDefaultData();
                    this.permissionsConfig.get("schema-version").raw(4);
                    return null;
                });
            }
            catch (PermissionsLoadingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PermissionsLoadingException(Messages.FILE_ERROR_INITIAL_DATA.tr(new Object[0]), (Throwable)e);
            }
            return false;
        }
        try {
            ConfigurationTransformation versionUpdater = SchemaMigrations.versionedMigration(this.getManager().logger());
            int startVersion = this.permissionsConfig.get("schema-version").getInt(-1);
            BasicConfigurationNode node = this.permissionsConfig.node();
            versionUpdater.apply(node);
            int endVersion = this.permissionsConfig.get("schema-version").getInt();
            if (endVersion > startVersion) {
                this.getManager().logger().info(Messages.FILE_SCHEMA_MIGRATION_SUCCESS.tr(permissionsFile, startVersion, endVersion));
                this.permissionsConfig.save(node);
            }
        }
        catch (ConfigurateException ex) {
            throw new PermissionsLoadingException(Messages.FILE_ERROR_SCHEMA_MIGRATION_SAVE.tr(new Object[0]), (Throwable)ex);
        }
        return true;
    }

    @Override
    public void close() {
        if (this.reloadService != null) {
            try {
                this.reloadService.close();
            }
            catch (IOException e) {
                this.getManager().logger().error("Unable to shut down FileDataStore watch service", (Throwable)e);
            }
            this.reloadService = null;
        }
    }

    private ConfigurationNode getSubjectsNode() {
        return this.permissionsConfig.get("subjects");
    }

    private CompletableFuture<Void> save() {
        if (this.saveSuppressed.get() <= 0) {
            return Util.asyncFailableFuture(() -> {
                this.saveSync();
                return null;
            }, this.getManager().asyncExecutor());
        }
        return CompletableFuture.completedFuture(null);
    }

    private void saveSync() throws ConfigurateException {
        if (this.saveSuppressed.get() <= 0 && this.dirty.compareAndSet(true, false)) {
            this.permissionsConfig.save();
        }
    }

    @Override
    public CompletableFuture<ImmutableSubjectData> getDataInternal(String type, String identifier) {
        try {
            return CompletableFuture.completedFuture(this.getDataSync(type, identifier));
        }
        catch (PermissionsLoadingException e) {
            return Util.failedFuture(e);
        }
    }

    private ImmutableSubjectData getDataSync(String type, String identifier) throws PermissionsLoadingException {
        try {
            return FileSubjectData.fromNode(this.getSubjectsNode().node(type, identifier));
        }
        catch (SerializationException e) {
            throw new PermissionsLoadingException(Messages.FILE_ERROR_DESERIALIZE_SUBJECT.tr(new Object[0]), (Throwable)e);
        }
    }

    @Override
    protected CompletableFuture<ImmutableSubjectData> setDataInternal(String type, String identifier, ImmutableSubjectData data) {
        try {
            if (data == null) {
                this.getSubjectsNode().node(type, identifier).raw(null);
                this.dirty.set(true);
                return this.save().thenApply(input -> null);
            }
            FileSubjectData fileData = data instanceof FileSubjectData ? (FileSubjectData)data : (FileSubjectData)new FileSubjectData().mergeFrom(data);
            fileData.serialize(this.getSubjectsNode().node(type, identifier));
            this.dirty.set(true);
            return this.save().thenApply(none2 -> fileData);
        }
        catch (SerializationException e) {
            return Util.failedFuture(e);
        }
    }

    @Override
    public CompletableFuture<Boolean> isRegistered(String type, String identifier) {
        return CompletableFuture.completedFuture(!this.getSubjectsNode().node(type, identifier).virtual());
    }

    @Override
    public Set<String> getAllIdentifiers(String type) {
        return this.getSubjectsNode().node(type).childrenMap().keySet();
    }

    @Override
    public Set<String> getRegisteredTypes() {
        return Collections.unmodifiableSet(this.getSubjectsNode().childrenMap().entrySet().stream().filter(ent -> ((ConfigurationNode)ent.getValue()).isMap()).map(Map.Entry::getKey).map(Object::toString).distinct().collect(Collectors.toSet()));
    }

    @Override
    public CompletableFuture<Set<String>> getDefinedContextKeys() {
        return CompletableFuture.completedFuture(this.getSubjectsNode().childrenMap().values().stream().flatMap(typeNode -> typeNode.childrenMap().values().stream()).flatMap(subjectNode -> subjectNode.childrenList().stream()).flatMap(segmentNode -> segmentNode.node("contexts").childrenMap().entrySet().stream()).map(ctx -> ctx.getKey().toString()).collect(Collectors.toSet()));
    }

    @Override
    public Iterable<Map.Entry<Map.Entry<String, String>, ImmutableSubjectData>> getAll() {
        return Iterables.concat((Iterable)Iterables.transform(this.getSubjectsNode().childrenMap().keySet(), type -> {
            if (type == null) {
                return null;
            }
            String typeStr = type.toString();
            return Iterables.transform(this.getAll(typeStr), input2 -> Maps.immutableEntry((Object)Maps.immutableEntry((Object)type.toString(), (Object)((String)input2.getKey())), (Object)((ImmutableSubjectData)input2.getValue())));
        }));
    }

    private ConfigurationNode getRankLaddersNode() {
        return this.permissionsConfig.get(KEY_RANK_LADDERS);
    }

    @Override
    public Iterable<String> getAllRankLadders() {
        return Iterables.unmodifiableIterable((Iterable)Iterables.transform(this.getRankLaddersNode().childrenMap().keySet(), Object::toString));
    }

    @Override
    public CompletableFuture<RankLadder> getRankLadderInternal(String ladder) {
        return CompletableFuture.completedFuture(new FixedRankLadder(ladder, this.getRankLaddersNode().node(ladder.toLowerCase()).childrenList().stream().map(node -> Util.subjectFromString(Objects.requireNonNull(node.getString()))).collect(Collectors.toList())));
    }

    @Override
    public CompletableFuture<Boolean> hasRankLadder(String ladder) {
        return CompletableFuture.completedFuture(!this.getRankLaddersNode().node(ladder.toLowerCase()).virtual());
    }

    @Override
    public CompletableFuture<ContextInheritance> getContextInheritanceInternal() {
        try {
            return CompletableFuture.completedFuture((ContextInheritance)this.permissionsConfig.node().get(MemoryContextInheritance.class));
        }
        catch (SerializationException e) {
            return Util.failedFuture(e);
        }
    }

    @Override
    public CompletableFuture<ContextInheritance> setContextInheritanceInternal(ContextInheritance inheritance) {
        MemoryContextInheritance realInheritance = MemoryContextInheritance.fromExistingContextInheritance(inheritance);
        try {
            this.permissionsConfig.node().set(MemoryContextInheritance.class, (Object)realInheritance);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        this.dirty.set(true);
        return this.save().thenApply(none2 -> realInheritance);
    }

    @Override
    public CompletableFuture<RankLadder> setRankLadderInternal(String identifier, RankLadder ladder) {
        ConfigurationNode childNode = this.getRankLaddersNode().node(identifier.toLowerCase());
        childNode.raw(null);
        if (ladder != null) {
            for (Map.Entry<String, String> entry : ladder.ranks()) {
                childNode.appendListNode().raw(Util.subjectToString(entry));
            }
        }
        this.dirty.set(true);
        return this.save().thenApply(none2 -> ladder);
    }

    @Override
    protected <T> T performBulkOperationSync(Function<DataStore, T> function) throws Exception {
        T ret;
        this.saveSuppressed.getAndIncrement();
        try {
            ret = function.apply(this);
        }
        finally {
            this.saveSuppressed.getAndDecrement();
        }
        this.saveSync();
        return ret;
    }

    @AutoService(value={DataStoreFactory.class})
    public static class Factory
    extends AbstractDataStore.Factory<FileDataStore, Config> {
        public Factory() {
            super("file", Config.class, FileDataStore::new);
        }
    }

    @ConfigSerializable
    static class Config {
        @Setting
        String file;
        @Setting
        @Comment(value="Place file entries in alphabetical order")
        boolean alphabetizeEntries = false;
        @Setting
        @Comment(value="Automatically reload the data file when changes have been made")
        boolean autoReload = true;

        Config() {
        }
    }
}

