/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.backend.memory;

import ca.stellardrift.permissionsex.context.ContextInheritance;
import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.datastore.DataStore;
import ca.stellardrift.permissionsex.datastore.DataStoreFactory;
import ca.stellardrift.permissionsex.datastore.StoreProperties;
import ca.stellardrift.permissionsex.exception.PermissionsLoadingException;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.BasicConfigurationNode;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.objectmapping.ConfigSerializable;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.objectmapping.meta.Comment;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.objectmapping.meta.Setting;
import ca.stellardrift.permissionsex.impl.backend.AbstractDataStore;
import ca.stellardrift.permissionsex.impl.backend.memory.MemoryContextInheritance;
import ca.stellardrift.permissionsex.impl.backend.memory.MemorySubjectData;
import ca.stellardrift.permissionsex.impl.config.FilePermissionsExConfiguration;
import ca.stellardrift.permissionsex.impl.rank.FixedRankLadder;
import ca.stellardrift.permissionsex.impl.util.GuavaCollectors;
import ca.stellardrift.permissionsex.rank.RankLadder;
import ca.stellardrift.permissionsex.subject.ImmutableSubjectData;
import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MemoryDataStore
extends AbstractDataStore<MemoryDataStore, Config> {
    private final ConcurrentMap<Map.Entry<String, String>, ImmutableSubjectData> data = new ConcurrentHashMap<Map.Entry<String, String>, ImmutableSubjectData>();
    private final ConcurrentMap<String, RankLadder> rankLadders = new ConcurrentHashMap<String, RankLadder>();
    private volatile ContextInheritance inheritance = new MemoryContextInheritance();

    public static MemoryDataStore create(String identifier) {
        try {
            return (MemoryDataStore)DataStoreFactory.forType("memory").create(identifier, BasicConfigurationNode.root(FilePermissionsExConfiguration.PEX_OPTIONS));
        }
        catch (PermissionsLoadingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public MemoryDataStore(StoreProperties<Config> properties) {
        super(properties);
    }

    @Override
    protected boolean initializeInternal() {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public CompletableFuture<ImmutableSubjectData> getDataInternal(String type, String identifier) {
        Map.Entry key = Maps.immutableEntry((Object)type, (Object)identifier);
        ImmutableSubjectData ret = (ImmutableSubjectData)this.data.get(key);
        if (ret == null) {
            ImmutableSubjectData existingData;
            ret = new MemorySubjectData();
            if (((Config)this.config()).track && (existingData = this.data.putIfAbsent(key, ret)) != null) {
                ret = existingData;
            }
        }
        return this.completedFuture(ret);
    }

    @Override
    public CompletableFuture<ImmutableSubjectData> setDataInternal(String type, String identifier, ImmutableSubjectData data) {
        if (((Config)this.config()).track) {
            this.data.put(Maps.immutableEntry((Object)type, (Object)identifier), data);
        }
        return this.completedFuture(data);
    }

    @Override
    protected CompletableFuture<RankLadder> getRankLadderInternal(String name) {
        RankLadder ladder = (RankLadder)this.rankLadders.get(name.toLowerCase());
        if (ladder == null) {
            ladder = new FixedRankLadder(name, (List<Map.Entry<String, String>>)ImmutableList.of());
        }
        return this.completedFuture(ladder);
    }

    @Override
    protected CompletableFuture<RankLadder> setRankLadderInternal(String ladder, RankLadder newLadder) {
        this.rankLadders.put(ladder, newLadder);
        return this.completedFuture(newLadder);
    }

    private <T> CompletableFuture<T> completedFuture(T i) {
        return CompletableFuture.supplyAsync(() -> i, this.getManager().asyncExecutor());
    }

    @Override
    public CompletableFuture<Boolean> isRegistered(String type, String identifier) {
        return this.completedFuture(this.data.containsKey(Maps.immutableEntry((Object)type, (Object)identifier)));
    }

    @Override
    public Set<String> getAllIdentifiers(String type) {
        return (Set)this.data.keySet().stream().filter(inp -> ((String)inp.getKey()).equals(type)).map(Map.Entry::getValue).collect(GuavaCollectors.toImmutableSet());
    }

    @Override
    public Set<String> getRegisteredTypes() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(this.data.keySet(), Map.Entry::getKey));
    }

    @Override
    public CompletableFuture<Set<String>> getDefinedContextKeys() {
        return CompletableFuture.completedFuture(this.data.values().stream().flatMap(data -> data.getActiveContexts().stream()).flatMap(Collection::stream).map(ContextValue::key).collect(Collectors.toSet()));
    }

    @Override
    public Iterable<Map.Entry<Map.Entry<String, String>, ImmutableSubjectData>> getAll() {
        return Iterables.unmodifiableIterable(this.data.entrySet());
    }

    @Override
    public Iterable<String> getAllRankLadders() {
        return ImmutableSet.copyOf(this.rankLadders.keySet());
    }

    @Override
    public CompletableFuture<Boolean> hasRankLadder(String ladder) {
        return this.completedFuture(this.rankLadders.containsKey(ladder.toLowerCase()));
    }

    @Override
    public CompletableFuture<ContextInheritance> getContextInheritanceInternal() {
        return this.completedFuture(this.inheritance);
    }

    @Override
    public CompletableFuture<ContextInheritance> setContextInheritanceInternal(ContextInheritance inheritance) {
        this.inheritance = inheritance;
        return this.completedFuture(this.inheritance);
    }

    @Override
    protected <T> T performBulkOperationSync(Function<DataStore, T> function) {
        return function.apply(this);
    }

    @AutoService(value={DataStoreFactory.class})
    public static final class Factory
    extends AbstractDataStore.Factory<MemoryDataStore, Config> {
        static final String TYPE = "memory";

        public Factory() {
            super(TYPE, Config.class, MemoryDataStore::new);
        }
    }

    @ConfigSerializable
    static class Config {
        @Setting
        @Comment(value="Whether or not this data store will store subjects being set")
        boolean track = true;

        Config() {
        }
    }
}

