/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.backend.memory;

import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.ext.org.jetbrains.annotations.Nullable;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.objectmapping.ConfigSerializable;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.objectmapping.ObjectMapper;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.objectmapping.meta.Setting;
import ca.stellardrift.permissionsex.ext.org.spongepowered.configurate.serialize.SerializationException;
import ca.stellardrift.permissionsex.impl.util.Util;
import ca.stellardrift.permissionsex.subject.ImmutableSubjectData;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MemorySubjectData
implements ImmutableSubjectData {
    protected static final ObjectMapper<DataEntry> MAPPER;
    protected final Map<Set<ContextValue<?>>, DataEntry> contexts;

    protected final MemorySubjectData newWithUpdated(Set<ContextValue<?>> key, DataEntry val) {
        if (val.isEmpty()) {
            val = null;
        }
        return this.newData(Util.updateImmutable(this.contexts, this.immutSet(key), val));
    }

    protected MemorySubjectData newData(Map<Set<ContextValue<?>>, DataEntry> contexts) {
        return new MemorySubjectData(contexts);
    }

    protected MemorySubjectData() {
        this.contexts = ImmutableMap.of();
    }

    protected MemorySubjectData(Map<Set<ContextValue<?>>, DataEntry> contexts) {
        this.contexts = contexts;
    }

    private DataEntry getDataEntryOrNew(Set<ContextValue<?>> contexts) {
        DataEntry res = this.contexts.get(contexts);
        if (res == null) {
            res = new DataEntry();
        }
        return res;
    }

    private <E> ImmutableSet<E> immutSet(Set<E> set) {
        return ImmutableSet.copyOf(set);
    }

    @Override
    public Map<Set<ContextValue<?>>, Map<String, String>> getAllOptions() {
        return Maps.filterValues((Map)Maps.transformValues(this.contexts, dataEntry -> dataEntry == null ? null : ((DataEntry)dataEntry).options), el -> el != null);
    }

    @Override
    public Map<String, String> getOptions(Set<ContextValue<?>> contexts) {
        DataEntry entry = this.contexts.get(contexts);
        return entry == null || entry.options == null ? Collections.emptyMap() : entry.options;
    }

    @Override
    public ImmutableSubjectData setOption(Set<ContextValue<?>> contexts, String key, String value) {
        if (value == null) {
            return this.newWithUpdated(contexts, this.getDataEntryOrNew(contexts).withoutOption(key));
        }
        return this.newWithUpdated(contexts, this.getDataEntryOrNew(contexts).withOption(key, value));
    }

    @Override
    public ImmutableSubjectData setOptions(Set<ContextValue<?>> contexts, Map<String, String> values) {
        return this.newWithUpdated(contexts, this.getDataEntryOrNew(contexts).withOptions(values));
    }

    @Override
    public ImmutableSubjectData clearOptions(Set<ContextValue<?>> contexts) {
        if (!this.contexts.containsKey(contexts)) {
            return this;
        }
        return this.newWithUpdated(contexts, this.getDataEntryOrNew(contexts).withoutOptions());
    }

    @Override
    public ImmutableSubjectData clearOptions() {
        if (this.contexts.isEmpty()) {
            return this;
        }
        Map newValue = Maps.transformValues(this.contexts, dataEntry -> dataEntry == null ? null : dataEntry.withoutOptions());
        return this.newData(newValue);
    }

    @Override
    public Map<Set<ContextValue<?>>, Map<String, Integer>> getAllPermissions() {
        return Maps.filterValues((Map)Maps.transformValues(this.contexts, dataEntry -> dataEntry == null ? null : ((DataEntry)dataEntry).permissions), o -> o != null);
    }

    @Override
    public Map<String, Integer> getPermissions(Set<ContextValue<?>> set) {
        DataEntry entry = this.contexts.get(set);
        return entry == null || entry.permissions == null ? Collections.emptyMap() : entry.permissions;
    }

    @Override
    public ImmutableSubjectData setPermission(Set<ContextValue<?>> contexts, String permission2, int value) {
        if (value == 0) {
            return this.newWithUpdated(contexts, this.getDataEntryOrNew(contexts).withoutPermission(permission2));
        }
        return this.newWithUpdated(contexts, this.getDataEntryOrNew(contexts).withPermission(permission2, value));
    }

    @Override
    public ImmutableSubjectData setPermissions(Set<ContextValue<?>> contexts, Map<String, Integer> values) {
        return this.newWithUpdated(contexts, this.getDataEntryOrNew(contexts).withPermissions(values));
    }

    @Override
    public ImmutableSubjectData clearPermissions() {
        if (this.contexts.isEmpty()) {
            return this;
        }
        Map newValue = Maps.transformValues(this.contexts, dataEntry -> dataEntry == null ? null : dataEntry.withoutPermissions());
        return this.newData(newValue);
    }

    @Override
    public ImmutableSubjectData clearPermissions(Set<ContextValue<?>> contexts) {
        if (!this.contexts.containsKey(contexts)) {
            return this;
        }
        return this.newWithUpdated(contexts, this.getDataEntryOrNew(contexts).withoutPermissions());
    }

    @Override
    public Map<Set<ContextValue<?>>, List<Map.Entry<String, String>>> getAllParents() {
        return Maps.filterValues((Map)Maps.transformValues(this.contexts, dataEntry -> dataEntry == null ? null : (((DataEntry)dataEntry).parents == null ? null : Lists.transform((List)((DataEntry)dataEntry).parents, Util::subjectFromString))), v -> v != null);
    }

    @Override
    public List<Map.Entry<String, String>> getParents(Set<ContextValue<?>> contexts) {
        DataEntry ent = this.contexts.get(contexts);
        return ent == null || ent.parents == null ? Collections.emptyList() : Lists.transform((List)ent.parents, Util::subjectFromString);
    }

    @Override
    public ImmutableSubjectData addParent(Set<ContextValue<?>> contexts, String type, String ident) {
        DataEntry entry = this.getDataEntryOrNew(contexts);
        String parentIdent = type + ":" + ident;
        if (entry.parents != null && entry.parents.contains(parentIdent)) {
            return this;
        }
        return this.newWithUpdated(contexts, entry.withAddedParent(parentIdent));
    }

    @Override
    public ImmutableSubjectData removeParent(Set<ContextValue<?>> contexts, String type, String identifier) {
        DataEntry ent = this.contexts.get(contexts);
        if (ent == null) {
            return this;
        }
        String combined = type + ":" + identifier;
        if (ent.parents == null || !ent.parents.contains(combined)) {
            return this;
        }
        return this.newWithUpdated(contexts, ent.withRemovedParent(combined));
    }

    @Override
    public ImmutableSubjectData setParents(Set<ContextValue<?>> contexts, List<Map.Entry<String, String>> parents) {
        DataEntry entry = this.getDataEntryOrNew(contexts);
        return this.newWithUpdated(contexts, entry.withParents(Lists.transform(parents, Util::subjectToString)));
    }

    @Override
    public ImmutableSubjectData clearParents() {
        if (this.contexts.isEmpty()) {
            return this;
        }
        Map newValue = Maps.transformValues(this.contexts, dataEntry -> dataEntry == null ? null : dataEntry.withoutParents());
        return this.newData(newValue);
    }

    @Override
    public ImmutableSubjectData clearParents(Set<ContextValue<?>> contexts) {
        if (!this.contexts.containsKey(contexts)) {
            return this;
        }
        return this.newWithUpdated(contexts, this.getDataEntryOrNew(contexts).withoutParents());
    }

    @Override
    public int getDefaultValue(Set<ContextValue<?>> contexts) {
        DataEntry ent = this.contexts.get(contexts);
        return ent == null || ent.defaultValue == null ? 0 : ent.defaultValue;
    }

    @Override
    public ImmutableSubjectData setDefaultValue(Set<ContextValue<?>> contexts, int defaultValue) {
        return this.newWithUpdated(contexts, this.getDataEntryOrNew(contexts).withDefaultValue(defaultValue));
    }

    @Override
    public Set<Set<ContextValue<?>>> getActiveContexts() {
        return this.contexts.keySet();
    }

    @Override
    public Map<Set<ContextValue<?>>, Integer> getAllDefaultValues() {
        return Maps.filterValues((Map)Maps.transformValues(this.contexts, dataEntry -> dataEntry == null ? null : ((DataEntry)dataEntry).defaultValue), v -> v != null);
    }

    public String toString() {
        return "MemoryOptionSubjectData{contexts=" + this.contexts + '}';
    }

    static {
        try {
            MAPPER = ObjectMapper.factory().get(DataEntry.class);
        }
        catch (SerializationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    @ConfigSerializable
    protected static class DataEntry {
        @Setting
        @Nullable
        private Map<String, Integer> permissions;
        @Setting
        @Nullable
        private Map<String, String> options;
        @Setting
        @Nullable
        private List<String> parents;
        @Setting(value="permissions-default")
        @Nullable
        private Integer defaultValue;

        private DataEntry(@Nullable Map<String, Integer> permissions, @Nullable Map<String, String> options2, @Nullable List<String> parents, @Nullable Integer defaultValue) {
            this.permissions = permissions;
            this.options = options2;
            this.parents = parents;
            this.defaultValue = defaultValue;
        }

        private DataEntry() {
        }

        public DataEntry withOption(String key, String value) {
            return new DataEntry(this.permissions, Util.updateImmutable(this.options, key, value), this.parents, this.defaultValue);
        }

        public DataEntry withoutOption(String key) {
            if (this.options == null || !this.options.containsKey(key)) {
                return this;
            }
            HashMap<String, String> newOptions = new HashMap<String, String>(this.options);
            newOptions.remove(key);
            return new DataEntry(this.permissions, newOptions, this.parents, this.defaultValue);
        }

        public DataEntry withOptions(Map<String, String> values) {
            return new DataEntry(this.permissions, (Map<String, String>)(values == null ? null : ImmutableMap.copyOf(values)), this.parents, this.defaultValue);
        }

        public DataEntry withoutOptions() {
            return new DataEntry(this.permissions, null, this.parents, this.defaultValue);
        }

        public DataEntry withPermission(String permission2, int value) {
            return new DataEntry(Util.updateImmutable(this.permissions, permission2, value), this.options, this.parents, this.defaultValue);
        }

        public DataEntry withoutPermission(String permission2) {
            if (this.permissions == null || !this.permissions.containsKey(permission2)) {
                return this;
            }
            HashMap<String, Integer> newPermissions = new HashMap<String, Integer>(this.permissions);
            newPermissions.remove(permission2);
            return new DataEntry(newPermissions, this.options, this.parents, this.defaultValue);
        }

        public DataEntry withPermissions(Map<String, Integer> values) {
            return new DataEntry((Map<String, Integer>)ImmutableMap.copyOf(values), this.options, this.parents, this.defaultValue);
        }

        public DataEntry withoutPermissions() {
            return new DataEntry(null, this.options, this.parents, this.defaultValue);
        }

        public DataEntry withDefaultValue(Integer defaultValue) {
            return new DataEntry(this.permissions, this.options, this.parents, defaultValue);
        }

        public DataEntry withAddedParent(String parent) {
            ImmutableList.Builder parents = ImmutableList.builder();
            parents.add((Object)parent);
            if (this.parents != null) {
                parents.addAll(this.parents);
            }
            return new DataEntry(this.permissions, this.options, (List<String>)parents.build(), this.defaultValue);
        }

        public DataEntry withRemovedParent(String parent) {
            if (this.parents == null || this.parents.isEmpty()) {
                return this;
            }
            ArrayList<String> newParents = new ArrayList<String>(this.parents);
            newParents.remove(parent);
            return new DataEntry(this.permissions, this.options, newParents, this.defaultValue);
        }

        public DataEntry withParents(List<String> transform) {
            return new DataEntry(this.permissions, this.options, (List<String>)(transform == null ? null : ImmutableList.copyOf(transform)), this.defaultValue);
        }

        public DataEntry withoutParents() {
            return new DataEntry(this.permissions, this.options, null, this.defaultValue);
        }

        public String toString() {
            return "DataEntry{permissions=" + this.permissions + ", options=" + this.options + ", parents=" + this.parents + ", defaultValue=" + this.defaultValue + '}';
        }

        public boolean isEmpty() {
            return !(this.permissions != null && !this.permissions.isEmpty() || this.options != null && !this.options.isEmpty() || this.parents != null && !this.parents.isEmpty() || this.defaultValue != null);
        }
    }
}

