/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.commands.parse;

import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.impl.commands.parse.ArgumentParseException;
import ca.stellardrift.permissionsex.impl.commands.parse.CommandArgs;
import ca.stellardrift.permissionsex.impl.commands.parse.Messages;
import java.util.ArrayList;
import java.util.Collections;

public class QuotedStringParser {
    private final boolean lenient;
    private final String buffer;
    private int index = -1;

    public static CommandArgs parseFrom(String args2, boolean lenient) throws ArgumentParseException {
        return new QuotedStringParser(args2, lenient).parse();
    }

    private QuotedStringParser(String args2, boolean lenient) {
        this.buffer = args2;
        this.lenient = lenient;
    }

    public CommandArgs parse() throws ArgumentParseException {
        if (this.buffer.length() == 0) {
            return new CommandArgs(this.buffer, Collections.emptyList());
        }
        ArrayList<CommandArgs.SingleArg> returnedArgs = new ArrayList<CommandArgs.SingleArg>(this.buffer.length() / 8);
        this.skipWhiteSpace();
        while (this.hasMore()) {
            int startIdx = this.index + 1;
            String arg = this.nextArg();
            returnedArgs.add(new CommandArgs.SingleArg(arg, startIdx, this.index));
            this.skipWhiteSpace();
        }
        return new CommandArgs(this.buffer, returnedArgs);
    }

    private boolean hasMore() {
        return this.index + 1 < this.buffer.length();
    }

    private int peek() throws ArgumentParseException {
        if (!this.hasMore()) {
            throw this.createException(Messages.ERROR_PARSE_BUFFEROVERRUN.tr(new Object[0]));
        }
        return this.buffer.codePointAt(this.index + 1);
    }

    private int next() throws ArgumentParseException {
        if (!this.hasMore()) {
            throw this.createException(Messages.ERROR_PARSE_BUFFEROVERRUN.tr(new Object[0]));
        }
        return this.buffer.codePointAt(++this.index);
    }

    public ArgumentParseException createException(Component message) {
        return new ArgumentParseException(message, this.buffer, this.index);
    }

    private void skipWhiteSpace() throws ArgumentParseException {
        if (!this.hasMore()) {
            return;
        }
        while (Character.isWhitespace(this.peek())) {
            this.next();
        }
    }

    private String nextArg() throws ArgumentParseException {
        StringBuilder argBuilder = new StringBuilder();
        int codePoint = this.peek();
        if (codePoint == 34 || codePoint == 39) {
            this.parseQuotedString(codePoint, argBuilder);
        } else {
            this.parseUnquotedString(argBuilder);
        }
        return argBuilder.toString();
    }

    private void parseQuotedString(int startQuotation, StringBuilder builder) throws ArgumentParseException {
        int nextCodePoint = this.next();
        if (nextCodePoint != startQuotation) {
            throw this.createException(Messages.ERROR_PARSE_NOTQUOTE.tr(nextCodePoint, startQuotation));
        }
        while (true) {
            if (!this.hasMore()) {
                if (this.lenient) {
                    return;
                }
                throw this.createException(Messages.ERROR_PARSE_UNTERMINATED_QUOTED.tr(new Object[0]));
            }
            nextCodePoint = this.next();
            if (nextCodePoint == startQuotation) {
                return;
            }
            if (nextCodePoint == 92) {
                this.parseEscape(builder);
                continue;
            }
            builder.appendCodePoint(nextCodePoint);
        }
    }

    private void parseUnquotedString(StringBuilder builder) throws ArgumentParseException {
        while (this.hasMore()) {
            int nextCodePoint = this.next();
            if (Character.isWhitespace(nextCodePoint)) {
                return;
            }
            if (nextCodePoint == 92) {
                this.parseEscape(builder);
                continue;
            }
            builder.appendCodePoint(nextCodePoint);
        }
    }

    private void parseEscape(StringBuilder builder) throws ArgumentParseException {
        builder.appendCodePoint(this.next());
    }
}

