/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.commands.parse;

import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.net.kyori.adventure.text.TextComponent;
import ca.stellardrift.permissionsex.ext.org.jetbrains.annotations.NotNull;
import ca.stellardrift.permissionsex.impl.commands.commander.Commander;
import ca.stellardrift.permissionsex.impl.commands.parse.ArgumentParseException;
import ca.stellardrift.permissionsex.impl.commands.parse.CommandArgs;
import ca.stellardrift.permissionsex.impl.commands.parse.CommandContext;
import ca.stellardrift.permissionsex.impl.commands.parse.CommandElement;
import ca.stellardrift.permissionsex.impl.commands.parse.Messages;
import ca.stellardrift.permissionsex.impl.commands.parse.Value;
import ca.stellardrift.permissionsex.impl.commands.parse.ValueElement;
import ca.stellardrift.permissionsex.impl.util.GuavaStartsWithPredicate;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StructuralArguments {
    private static CommandElement markTrue(String flag) {
        return new MarkTrueCommandElement().key(flag);
    }

    public static FlagCommandElementBuilder flags() {
        return new FlagCommandElementBuilder();
    }

    public static CommandElement seq(CommandElement ... elements) {
        return new SequenceCommandElement((List<CommandElement>)ImmutableList.copyOf((Object[])elements));
    }

    public static CommandElement firstParsing(CommandElement ... elements) {
        return new FirstParsingCommandElement((List)ImmutableList.copyOf((Object[])elements));
    }

    public static CommandElement optional(CommandElement element) {
        return new OptionalCommandElement(element, null, false);
    }

    public static CommandElement optionalWeak(CommandElement element) {
        return new OptionalCommandElement(element, null, true);
    }

    public static CommandElement optional(CommandElement element, Object value) {
        return new OptionalCommandElement(element, value, false);
    }

    public static CommandElement optionalWeak(CommandElement element, Object value) {
        return new OptionalCommandElement(element, value, true);
    }

    public static CommandElement repeated(CommandElement element, int times) {
        return new RepeatedCommandElement(element, times);
    }

    public static CommandElement allOf(CommandElement element) {
        return new AllOfCommandElement(element);
    }

    private static class AllOfCommandElement
    extends CommandElement {
        private final CommandElement element;

        protected AllOfCommandElement(CommandElement element) {
            this.element = element;
        }

        @Override
        public void parse(CommandArgs args2, CommandContext context) throws ArgumentParseException {
            while (args2.hasNext()) {
                this.element.parse(args2, context);
            }
        }

        @Override
        public List<String> tabComplete(Commander src, CommandArgs args2, CommandContext context) {
            while (args2.hasNext()) {
                int startPos = args2.getPosition();
                try {
                    this.element.parse(args2, context);
                }
                catch (ArgumentParseException e) {
                    args2.setPosition(startPos);
                    return this.element.tabComplete(src, args2, context);
                }
            }
            return Collections.emptyList();
        }

        @Override
        public Component getUsage(Commander context) {
            return this.element.getUsage(context).append(Component.text("+"));
        }
    }

    private static class RepeatedCommandElement
    extends CommandElement {
        private final CommandElement element;
        private final int times;

        protected RepeatedCommandElement(CommandElement element, int times) {
            this.element = element;
            this.times = times;
        }

        @Override
        public void parse(CommandArgs args2, CommandContext context) throws ArgumentParseException {
            for (int i = 0; i < this.times; ++i) {
                this.element.parse(args2, context);
            }
        }

        @Override
        public List<String> tabComplete(Commander src, CommandArgs args2, CommandContext context) {
            for (int i = 0; i < this.times; ++i) {
                int startPos = args2.getPosition();
                try {
                    this.element.parse(args2, context);
                    continue;
                }
                catch (ArgumentParseException e) {
                    args2.setPosition(startPos);
                    return this.element.tabComplete(src, args2, context);
                }
            }
            return Collections.emptyList();
        }

        @Override
        public Component getUsage(Commander src) {
            return ((TextComponent.Builder)((TextComponent.Builder)Component.text().content(String.valueOf(this.times)).append((Component)Component.text("*"))).append(this.element.getUsage(src))).build();
        }
    }

    private static class OptionalCommandElement
    extends CommandElement {
        private final CommandElement element;
        private final Object value;
        private final boolean considerInvalidFormatEmpty;

        private OptionalCommandElement(CommandElement element, Object value, boolean considerInvalidFormatEmpty) {
            this.element = element;
            this.value = value;
            this.considerInvalidFormatEmpty = considerInvalidFormatEmpty;
        }

        @Override
        public void parse(CommandArgs args2, CommandContext context) throws ArgumentParseException {
            if (!args2.hasNext()) {
                return;
            }
            int startPos = args2.getPosition();
            try {
                this.element.parse(args2, context);
            }
            catch (ArgumentParseException ex) {
                if (this.considerInvalidFormatEmpty || args2.hasNext()) {
                    args2.setPosition(startPos);
                }
                throw ex;
            }
        }

        @Override
        public List<String> tabComplete(Commander src, CommandArgs args2, CommandContext context) {
            return this.element.tabComplete(src, args2, context);
        }

        @Override
        public Component getUsage(Commander src) {
            return Component.text(builder -> {
                builder.append((Component)Component.text("["));
                builder.append(this.element.getUsage(src));
                builder.append((Component)Component.text("]"));
            });
        }
    }

    private static class FirstParsingCommandElement
    extends CommandElement {
        private final List<CommandElement> elements;

        private FirstParsingCommandElement(List<CommandElement> elements) {
            this.elements = elements;
        }

        @Override
        public void parse(CommandArgs args2, CommandContext context) throws ArgumentParseException {
            ArgumentParseException firstException = null;
            for (CommandElement element : this.elements) {
                int startIndex = args2.getPosition();
                try {
                    element.parse(args2, context);
                    return;
                }
                catch (ArgumentParseException ex) {
                    if (firstException == null) {
                        firstException = ex;
                    }
                    args2.setPosition(startIndex);
                }
            }
            if (firstException != null) {
                throw firstException;
            }
        }

        @Override
        public List<String> tabComplete(Commander src, CommandArgs args2, CommandContext context) {
            return ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform(this.elements, input -> {
                int startIndex = args2.getPosition();
                List<String> ret = input.tabComplete(src, args2, context);
                args2.setPosition(startIndex);
                return ret;
            })));
        }

        @Override
        public Component getUsage(Commander commander) {
            return Component.text(builder -> {
                Iterator<CommandElement> it = this.elements.iterator();
                while (it.hasNext()) {
                    builder.append(it.next().getUsage(commander));
                    if (!it.hasNext()) continue;
                    builder.append((Component)Component.text("|"));
                }
            });
        }
    }

    static class SequenceCommandElement
    extends CommandElement {
        private final List<CommandElement> elements;

        SequenceCommandElement(List<CommandElement> elements) {
            this.elements = elements;
        }

        @Override
        public void parse(CommandArgs args2, CommandContext context) throws ArgumentParseException {
            for (CommandElement element : this.elements) {
                element.parse(args2, context);
            }
        }

        @Override
        public List<String> tabComplete(Commander src, CommandArgs args2, CommandContext context) {
            Iterator<CommandElement> it = this.elements.iterator();
            while (it.hasNext()) {
                CommandElement element = it.next();
                int startPos = args2.getPosition();
                try {
                    element.parse(args2, context);
                    int endPos = args2.getPosition();
                    if (!args2.hasNext()) {
                        args2.setPosition(startPos);
                        List<String> inputs = element.tabComplete(src, args2, context);
                        args2.setPosition(args2.getPosition() - 1);
                        if (!inputs.contains(args2.next())) {
                            return inputs;
                        }
                        args2.setPosition(endPos);
                    }
                }
                catch (ArgumentParseException e) {
                    args2.setPosition(startPos);
                    return element.tabComplete(src, args2, context);
                }
                if (it.hasNext()) continue;
                args2.setPosition(startPos);
            }
            return Collections.emptyList();
        }

        @Override
        public Component getUsage(Commander commander) {
            return Component.text(builder -> {
                Iterator<CommandElement> it = this.elements.iterator();
                while (it.hasNext()) {
                    builder.append(it.next().getUsage(commander));
                    if (!it.hasNext()) continue;
                    builder.append((Component)Component.space());
                }
            });
        }
    }

    private static class FlagCommandElement
    extends CommandElement {
        private final CommandElement childElement;
        private final Map<List<String>, CommandElement> usageFlags;
        private final Map<String, CommandElement> shortFlags;
        private final Map<String, CommandElement> longFlags;
        private final UnknownFlagBehavior unknownShortFlagBehavior;
        private final UnknownFlagBehavior unknownLongFlagBehavior;
        private final boolean anchorFlags;

        protected FlagCommandElement(CommandElement childElement, Map<List<String>, CommandElement> usageFlags, Map<String, CommandElement> shortFlags, Map<String, CommandElement> longFlags, UnknownFlagBehavior unknownShortFlagBehavior, UnknownFlagBehavior unknownLongFlagBehavior, boolean anchorFlags) {
            this.childElement = childElement;
            this.usageFlags = usageFlags;
            this.shortFlags = shortFlags;
            this.longFlags = longFlags;
            this.unknownShortFlagBehavior = unknownShortFlagBehavior;
            this.unknownLongFlagBehavior = unknownLongFlagBehavior;
            this.anchorFlags = anchorFlags;
        }

        @Override
        public void parse(CommandArgs args2, CommandContext context) throws ArgumentParseException {
            int startIdx = args2.getPosition();
            while (args2.hasNext()) {
                String arg = args2.next();
                if (arg.startsWith("-")) {
                    boolean ignored;
                    int flagStartIdx = args2.getPosition();
                    if (arg.startsWith("--")) {
                        String longFlag = arg.substring(2);
                        ignored = !this.parseLongFlag(longFlag, args2, context);
                    } else {
                        boolean bl = ignored = !this.parseShortFlags(arg = arg.substring(1), args2, context);
                    }
                    if (ignored) continue;
                    args2.removeArgs(flagStartIdx, args2.getPosition());
                    continue;
                }
                if (!this.anchorFlags) continue;
            }
            args2.setPosition(startIdx);
            if (this.childElement != null) {
                this.childElement.parse(args2, context);
            }
        }

        private boolean parseLongFlag(String longFlag, CommandArgs args2, CommandContext context) throws ArgumentParseException {
            if (longFlag.isEmpty()) {
                return false;
            }
            if (longFlag.contains("=")) {
                String[] flagSplit = longFlag.split("=", 2);
                longFlag = flagSplit[0];
                String value = flagSplit[1];
                CommandElement element = this.longFlags.get(longFlag.toLowerCase());
                if (element == null) {
                    switch (this.unknownLongFlagBehavior) {
                        case ERROR: {
                            throw args2.createError(Messages.FLAG_ERROR_UNKNOWNLONG.tr(longFlag));
                        }
                        case ACCEPT_NONVALUE: {
                            context.putArg(longFlag, (Object)value);
                            break;
                        }
                        case IGNORE: {
                            return false;
                        }
                    }
                } else {
                    args2.insertArg(value);
                    element.parse(args2, context);
                }
            } else {
                CommandElement element = this.longFlags.get(longFlag.toLowerCase());
                if (element == null) {
                    switch (this.unknownLongFlagBehavior) {
                        case ERROR: {
                            throw args2.createError(Messages.FLAG_ERROR_UNKNOWNLONG.tr(longFlag));
                        }
                        case ACCEPT_NONVALUE: {
                            context.putArg(longFlag, (Object)true);
                            break;
                        }
                        case IGNORE: {
                            return false;
                        }
                    }
                    context.putArg(longFlag, (Object)true);
                } else {
                    element.parse(args2, context);
                }
            }
            return true;
        }

        private boolean parseShortFlags(String shortFlags, CommandArgs args2, CommandContext context) throws ArgumentParseException {
            if (shortFlags.isEmpty()) {
                return false;
            }
            for (int i = 0; i < shortFlags.length(); ++i) {
                String flagChar = shortFlags.substring(i, i + 1);
                CommandElement element = this.shortFlags.get(flagChar);
                if (element == null) {
                    switch (this.unknownShortFlagBehavior) {
                        case IGNORE: {
                            if (i == 0) {
                                return false;
                            }
                        }
                        case ERROR: {
                            throw args2.createError(Messages.FLAG_ERROR_UNKNOWNSHORT.tr(flagChar));
                        }
                        case ACCEPT_NONVALUE: {
                            context.putArg(flagChar, (Object)true);
                        }
                    }
                    continue;
                }
                element.parse(args2, context);
            }
            return true;
        }

        @Override
        public Component getUsage(Commander src) {
            return Component.text(builder -> {
                for (Map.Entry<List<String>, CommandElement> arg : this.usageFlags.entrySet()) {
                    builder.append((Component)Component.text("["));
                    Iterator<String> it = arg.getKey().iterator();
                    while (it.hasNext()) {
                        builder.append((Component)Component.text("-"));
                        builder.append((Component)Component.text(it.next()));
                        if (!it.hasNext()) continue;
                        builder.append((Component)Component.text("|"));
                    }
                    if (!(arg.getValue() instanceof ValueElement) || !(((ValueElement)arg.getValue()).getValue() instanceof MarkTrueCommandElement)) {
                        builder.append((Component)Component.text(" "));
                        builder.append(arg.getValue().getUsage(src));
                    }
                    builder.append((Component)Component.text("]"));
                    builder.append((Component)Component.text(" "));
                }
                if (this.childElement != null) {
                    builder.append(this.childElement.getUsage(src));
                }
            });
        }

        @Override
        public List<String> tabComplete(Commander src, CommandArgs args2, CommandContext context) {
            int startIdx = args2.getPosition();
            while (args2.hasNext()) {
                String arg = args2.nextIfPresent();
                if (arg.startsWith("-")) {
                    String argStr;
                    String longFlag;
                    List<String> ret;
                    int flagStartIdx = args2.getPosition();
                    if (arg.startsWith("--") ? (ret = this.tabCompleteLongFlag(longFlag = arg.substring(2), src, args2, context)) != null : (ret = this.tabCompleteShortFlags(argStr = arg.substring(1), src, args2, context)) != null) {
                        return ret;
                    }
                    args2.removeArgs(flagStartIdx, args2.getPosition());
                    continue;
                }
                if (!this.anchorFlags) continue;
            }
            args2.setPosition(startIdx);
            if (this.childElement != null) {
                return this.childElement.tabComplete(src, args2, context);
            }
            return Collections.emptyList();
        }

        private List<String> tabCompleteLongFlag(String longFlag, Commander src, CommandArgs args2, CommandContext context) {
            if (longFlag.isEmpty()) {
                return null;
            }
            if (longFlag.contains("=")) {
                String[] flagSplit = longFlag.split("=", 2);
                longFlag = flagSplit[0];
                String value = flagSplit[1];
                CommandElement element = this.longFlags.get(longFlag.toLowerCase());
                if (element == null) {
                    if (this.unknownLongFlagBehavior != UnknownFlagBehavior.IGNORE) {
                        context.putArg(longFlag, (Object)value);
                    }
                } else {
                    args2.insertArg(value);
                    String finalLongFlag = longFlag;
                    int position = args2.getPosition();
                    try {
                        element.parse(args2, context);
                    }
                    catch (ArgumentParseException ex) {
                        args2.setPosition(position);
                        return ImmutableList.copyOf((Iterable)Iterables.transform(element.tabComplete(src, args2, context), input -> "--" + finalLongFlag + "=" + input));
                    }
                }
            } else {
                CommandElement element = this.longFlags.get(longFlag.toLowerCase());
                if (element == null) {
                    return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter(this.longFlags.keySet(), (Predicate)new GuavaStartsWithPredicate(longFlag.toLowerCase())), input -> "--" + input));
                }
                boolean complete = false;
                int position = args2.getPosition();
                try {
                    element.parse(args2, context);
                }
                catch (ArgumentParseException ex) {
                    complete = true;
                }
                if (!args2.hasNext()) {
                    complete = true;
                }
                if (complete) {
                    args2.setPosition(position);
                    return element.tabComplete(src, args2, context);
                }
            }
            return null;
        }

        private List<String> tabCompleteShortFlags(String shortFlags, Commander src, CommandArgs args2, CommandContext context) {
            if (shortFlags.isEmpty()) {
                return null;
            }
            for (int i = 0; i < shortFlags.length(); ++i) {
                String flagChar = shortFlags.substring(i, i + 1);
                CommandElement element = this.shortFlags.get(flagChar);
                if (element == null) continue;
                int start = args2.getPosition();
                try {
                    element.parse(args2, context);
                    continue;
                }
                catch (ArgumentParseException ex) {
                    args2.setPosition(start);
                    return element.tabComplete(src, args2, context);
                }
            }
            return null;
        }
    }

    public static class FlagCommandElementBuilder {
        private final Map<List<String>, CommandElement> usageFlags = new HashMap<List<String>, CommandElement>();
        private final Map<String, CommandElement> shortFlags = new HashMap<String, CommandElement>();
        private final Map<String, CommandElement> longFlags = new HashMap<String, CommandElement>();
        private UnknownFlagBehavior unknownLongFlagBehavior = UnknownFlagBehavior.ERROR;
        private UnknownFlagBehavior unknownShortFlagBehavior = UnknownFlagBehavior.ERROR;
        private boolean anchorFlags = false;

        public FlagCommandElementBuilder flag(String ... specs) {
            ArrayList<String> availableFlags = new ArrayList<String>(specs.length);
            CommandElement el = null;
            for (String spec : specs) {
                if (spec.startsWith("-")) {
                    String flagKey = spec.substring(1);
                    if (el == null) {
                        el = StructuralArguments.markTrue(flagKey);
                    }
                    availableFlags.add(flagKey);
                    this.longFlags.put(flagKey.toLowerCase(), el);
                    continue;
                }
                for (int i = 0; i < spec.length(); ++i) {
                    String flagKey = spec.substring(i, i + 1);
                    if (el == null) {
                        el = StructuralArguments.markTrue(flagKey);
                    }
                    availableFlags.add(flagKey);
                    this.shortFlags.put(flagKey, el);
                }
            }
            this.usageFlags.put(availableFlags, el);
            return this;
        }

        public FlagCommandElementBuilder valueFlag(CommandElement value, String ... specs) {
            ArrayList<String> availableFlags = new ArrayList<String>(specs.length);
            String valueStore = null;
            for (String spec : specs) {
                if (spec.startsWith("-")) {
                    availableFlags.add(spec);
                    String flagKey = spec.substring(1);
                    if (valueStore == null) {
                        valueStore = flagKey;
                    }
                    this.longFlags.put(flagKey.toLowerCase(), value);
                    continue;
                }
                for (int i = 0; i < spec.length(); ++i) {
                    String flagKey = spec.substring(i, i + 1);
                    if (valueStore == null) {
                        valueStore = flagKey;
                    }
                    availableFlags.add(flagKey);
                    this.shortFlags.put(flagKey, value);
                }
            }
            this.usageFlags.put(availableFlags, StructuralArguments.markTrue(valueStore));
            return this;
        }

        public FlagCommandElementBuilder setUnknownLongFlagBehavior(UnknownFlagBehavior behavior) {
            this.unknownLongFlagBehavior = behavior;
            return this;
        }

        public FlagCommandElementBuilder setUnknownShortFlagBehavior(UnknownFlagBehavior behavior) {
            this.unknownShortFlagBehavior = behavior;
            return this;
        }

        public FlagCommandElementBuilder setAnchorFlags(boolean anchorFlags) {
            this.anchorFlags = anchorFlags;
            return this;
        }

        public CommandElement buildWith(CommandElement wrapped) {
            return new FlagCommandElement(wrapped, this.usageFlags, this.shortFlags, this.longFlags, this.unknownShortFlagBehavior, this.unknownLongFlagBehavior, this.anchorFlags);
        }
    }

    private static class MarkTrueCommandElement
    extends Value<Boolean> {
        static final MarkTrueCommandElement INSTANCE = new MarkTrueCommandElement();

        private MarkTrueCommandElement() {
            super(Component.text("true"));
        }

        @Override
        public Boolean parse(@NotNull CommandArgs args2) throws ArgumentParseException {
            return true;
        }

        public ValueElement<Boolean> key(String key) {
            return this.key(Component.text(key));
        }
    }

    public static enum UnknownFlagBehavior {
        ERROR,
        ACCEPT_NONVALUE,
        ACCEPT_VALUE,
        IGNORE;

    }
}

